package com.pcloud.book.consumer.reader;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.pcloud.common.utils.string.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import com.alibaba.druid.support.json.JSONUtils;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.readercenter.wechat.dto.WechatUserRobotDto;
import com.pcloud.readercenter.wechat.entity.WechatUser;
import com.pcloud.readercenter.wechat.service.WechatUserService;

/**
 * @author lily
 * @date 2018/12/26 16:49
 */
@Component("readerConsr")
public class ReaderConsr {
    /**
     * logger
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(ReaderConsr.class);

    @Autowired
    private WechatUserService wechatUserService;

    public WechatUser getWechatUser(Long wechatUserId) throws BizException {
        if (wechatUserId == null) {
            return null;
        }
        try {
            return ResponseHandleUtil.parseResponse(wechatUserService.getWechatUser(wechatUserId), WechatUser.class);
        } catch (Exception e) {
            LOGGER.error("获取微信用户信息失败[wechatUserService.getWechatUser]:" + e.getMessage(), e);
        }
        return null;
    }

    public Map<Long, WechatUser> getUserList(List<Long> wechatUserIds) throws BizException {
        if (ListUtils.isEmpty(wechatUserIds)) {
            return new HashMap<>();
        }
        try {
            return ResponseHandleUtil.parseMap(wechatUserService.getUserList(wechatUserIds), Long.class, WechatUser.class);
        } catch (Exception e) {
            LOGGER.error("获取微信用户信息失败[wechatUserService.getUserList]:" + e.getMessage(), e);
        }
        return null;
    }

    @ParamLog(value = "随机获取n个用户", isAfterReturn = false)
    public List<WechatUserRobotDto> selectRobotsRandom(Integer number) throws BizException {
        if (number == null) {
            return null;
        }
        try {
            return ResponseHandleUtil.parseListResponse(wechatUserService.selectRobotsRandom(number), WechatUserRobotDto.class);
        } catch (Exception e) {
            LOGGER.error("随机获取n个用户失败[wechatUserService.getWechatUserRand]:" + e.getMessage(), e);
        }
        return null;
    }


    @ParamLog("获取9个用户头像")
    public String getNineHeadUrl() {
        List<WechatUserRobotDto> wechatUsers = this.selectRobotsRandom(9);
        if (ListUtils.isEmpty(wechatUsers)) {
            return "";
        }
        List<String> headUrls = wechatUsers.stream().map(a -> a.getWechatUserHeadUrl()).collect(Collectors.toList());
        return JSONUtils.toJSONString(headUrls);
    }

    @ParamLog(value = "获取wechatUserId", isAfterReturn = false)
    public Long getWechatUserId(String wxUserId,Long channelId) throws BizException {
        if (channelId == null || StringUtil.isEmpty(wxUserId)) {
            return null;
        }
        try {
            return ResponseHandleUtil.parseResponse(wechatUserService.getWechatUserId(wxUserId,channelId), Long.class);
        } catch (Exception e) {
            LOGGER.error("获取wechatUserId失败[wechatUserService.getWechatUserId]:" + e.getMessage(), e);
        }
        return null;
    }

}


