package com.pcloud.book.group.facade;

import com.pcloud.book.group.vo.GroupQrcodeBaseInfoVO;
import com.pcloud.book.group.vo.ListQrcodeByClassifyParamVO;
import com.pcloud.book.group.vo.WechatGroupNameVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;

import org.codehaus.jackson.JsonParseException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

/**
 * @author lily
 * @date 2019/4/19 15:34
 */
@Api(description = "群分类下的群")
public interface GroupQrcodeFacade {

    @ApiOperation(value = "根据分类获取分类下二维码", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "listQrcodeByClassifyParamVO", value = "群二维码查询参数", dataType = "ListQrcodeByClassifyParamVO", paramType = "body")})
    @RequestMapping(value = "listQrcodeByClassify", method = RequestMethod.POST)
    ResponseDto<PageBeanNew> listQrcodeByClassify(@RequestHeader("token") String token, @RequestBody ListQrcodeByClassifyParamVO listQrcodeByClassifyParamVO) throws PermissionException;

    @ApiOperation(value = "根据分类获取分类下二维码----不分页", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookGroupId", value = "bookGroupId", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "classifyId", value = "classifyId", dataType = "Long", paramType = "query")
    })
    @RequestMapping(value = "getQrcodeByClassify", method = RequestMethod.GET)
    ResponseDto<?> getQrcodeByClassify(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId,
                                       @RequestParam("classifyId") Long classifyId) throws PermissionException;

    @ApiOperation(value = "修改微信群名称", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "wechatGroupNameVO", value = "wechatGroupNameVO", dataType = "WechatGroupNameVO", paramType = "body")
    })
    @PostMapping("modifyWechatGroupName")
    ResponseDto<?> modifyWechatGroupName(@RequestHeader("token") String token, @RequestBody WechatGroupNameVO wechatGroupNameVO)
            throws BizException, JsonParseException, PermissionException;


    @ApiOperation(value = "获取群基本信息", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "groupQrcodeId", value = "群标识", dataType = "Long", paramType = "query")
    })
    @GetMapping("getBaseById")
    ResponseDto<GroupQrcodeBaseInfoVO> getBaseById(@RequestHeader("token") String token, @RequestParam("groupQrcodeId") Long groupQrcodeId)
            throws BizException, JsonParseException, PermissionException;

    @ApiOperation(value = "获取编辑下二维码", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "name", value = "名称", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query")
    })
    @RequestMapping(value = "listQrcodeByAdviser", method = RequestMethod.GET)
    ResponseDto<PageBeanNew> listQrcodeByAdviser(
            @RequestHeader("token") String token, @RequestParam(value = "currentPage", required = false) Integer currentPage,
            @RequestParam(value = "numPerPage", required = false) Integer numPerPage,@RequestParam(value = "name", required = false) String name) throws PermissionException;
}
