package com.pcloud.book.advertising.dao;

import com.pcloud.book.advertising.entity.AdvertisingPut;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

public interface AdvertisingPutDao extends BaseDao<AdvertisingPut> {
    Integer batchInsert(List<AdvertisingPut> advertisingPuts);

    /**
     * 根据计划id查询
     */
    List<AdvertisingPut> getListByPlanId(Long planId);

    /**
     * 根据id集合删除
     */
    void deleteByIds(List<Long> ids, Long partyId);

    /**
     * 根据计划id结合查询
     */
    List<AdvertisingPut> getListByPlanIds(List<Long> planIds);
}
