package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.AdvertisingClickRecordDao;
import com.pcloud.book.advertising.dto.WechatGroupClickUserDTO;
import com.pcloud.book.advertising.entity.AdvertisingClickRecord;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Description 广告位点击记录数据访问层接口实现类
 * @author PENG
 * @date 2019/2/28
 */
@Repository("advertisingClickRecordDao")
public class AdvertisingClickRecordDaoImpl extends BaseDaoImpl<AdvertisingClickRecord> implements AdvertisingClickRecordDao {

    /**
     * 微信群广告位点击读者列表
     */
    @Override
    public List<WechatGroupClickUserDTO> clickUserList4AdvertisingWechatGroup(Map<String, Object> paramMap) {
        return super.getSqlSession().selectList(getStatement("clickUserList4AdvertisingWechatGroup"), paramMap);
    }

    @Override
    public Long getClickUserNumByMasterId(Long masterId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("masterId", masterId);
        Long clickNum = super.getSqlSession().selectOne(getStatement("getClickUserNumByMasterId"),paramMap);
        return null == clickNum ? 0L : clickNum;
    }

    @Override
    public Long getClickUserNumByQrcode(Long qrcodeId, Long adId, String statisMonth) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("qrcodeId", qrcodeId);
        paramMap.put("adId", adId);
        paramMap.put("statisMonth", statisMonth);
        return getSessionTemplate().selectOne(getStatement("getClickUserNumByGroupQrcodeId"), paramMap);
    }

    @Override
    public Long getClickUserNumByAdId(Long adId, Long bookId, Long adviserId, Long channelId, String statisMonth) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("adId", adId);
        paramMap.put("statisMonth", statisMonth);
        paramMap.put("adviserId", adviserId);
        paramMap.put("channelId", channelId);
        paramMap.put("statisMonth", statisMonth);
        return getSessionTemplate().selectOne(getStatement("getClickUserNumByAdId"), paramMap);
    }
}
