package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.AdvertisingPutDao;
import com.pcloud.book.advertising.entity.AdvertisingPut;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/6/27 15:37
 **/
@Repository("advertisingPutDao")
public class AdvertisingPutDaoImpl extends BaseDaoImpl<AdvertisingPut> implements AdvertisingPutDao {
    @Override
    public Integer batchInsert(List<AdvertisingPut> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"), list);
    }

    @Override
    public List<AdvertisingPut> getListByPlanId(Long planId) {
        return super.getSqlSession().selectList(getStatement("getListByPlanId"), planId);
    }

    @Override
    public void deleteByIds(List<Long> ids, Long partyId) {
        Map<String, Object> map = new HashMap<>();
        map.put("ids", ids);
        map.put("partyId", partyId);
        super.getSqlSession().delete(getStatement("deleteByIds"), map);
    }

    @Override
    public List<AdvertisingPut> getListByPlanIds(List<Long> planIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("planIds", planIds);
        return super.getSqlSession().selectList(getStatement("getListByPlanIds"), map);
    }
}
