package com.pcloud.book.advertising.dto;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;

public class AdvertisingSettlementMethodDTO extends BaseDto {

    private static final long serialVersionUID = 8723754417913443287L;

    /**
     * advertising_settlement_method.id (唯一标识)
     */
    private Long id;

    /**
     * advertising_settlement_method.master_id (广告主ID)
     */
    private Long masterId;

    /**
     * advertising_settlement_method.ad_id (广告位ID)
     */
    private Long adId;

    /**
     * advertising_settlement_method.settlement_method (结算方式)
     */
    private String settlementMethod;

    /**
     * 结算方式名称
     */
    private String settlementMethodName;

    /**
     * advertising_settlement_method.price_each_time (每次价格)
     */
    private BigDecimal priceEachTime;

    /**
     * advertising_settlement_method.create_time (创建时间)
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     * advertising_settlement_method.update_time (修改时间)
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMasterId() {
        return masterId;
    }

    public void setMasterId(Long masterId) {
        this.masterId = masterId;
    }

    public Long getAdId() {
        return adId;
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    public String getSettlementMethod() {
        return settlementMethod;
    }

    public void setSettlementMethod(String settlementMethod) {
        this.settlementMethod = settlementMethod;
    }

    public String getSettlementMethodName() {
        return settlementMethodName;
    }

    public void setSettlementMethodName(String settlementMethodName) {
        this.settlementMethodName = settlementMethodName;
    }

    public BigDecimal getPriceEachTime() {
        return priceEachTime;
    }

    public void setPriceEachTime(BigDecimal priceEachTime) {
        this.priceEachTime = priceEachTime;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    public String toString() {
        return "AdvertisingSettlementMethodDTO{" +
                "id=" + id +
                ", masterId=" + masterId +
                ", adId=" + adId +
                ", settlementMethod='" + settlementMethod + '\'' +
                ", settlementMethodName='" + settlementMethodName + '\'' +
                ", priceEachTime=" + priceEachTime +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                "} " + super.toString();
    }
}