package com.pcloud.book.advertising.entity;

import java.util.Date;
import java.util.List;
import com.pcloud.book.book.entity.BookAdviser;
import com.pcloud.common.entity.BaseEntity;

/**
 * @author PENG
 */
public class AdvertisingDistributionBook extends BaseEntity {

    private static final long serialVersionUID = -7658299195342462203L;

    /**
     * advertising_distribution_book.id (唯一标识)
     */
    private Long id;

    /**
     * advertising_distribution_book.ad_id (广告位ID)
     */
    private Long adId;

    /**
     * advertising_distribution_book.book_id (书刊ID)
     */
    private Long bookId;

    /**
     * advertising_distribution_book.adviser_id (编辑ID)
     */
    private Long adviserId;

    /**
     * advertising_distribution_book.agent_id (出版ID)
     */
    private Long agentId;

    /**
     * advertising_distribution_book.channel_id (运营ID)
     */
    private Long channelId;

    /**
     * advertising_distribution_book.is_book_group (是否是社群书)
     */
    private Boolean isBookGroup;

    /**
     * advertising_distribution_book.classify_id (群分类ID)
     */
    private Long classifyId;

    /**
     * advertising_distribution_book.qrcode_id (微信群ID)
     */
    private Long qrcodeId;

    /**
     * advertising_distribution_book.distribution_time (投放时间)
     */
    private Date distributionTime;

    /**
     * 书刊列表
     */
    private List<BookAdviser> books;

    /**
     * 微信群列表
     */
    private List<DistributionWechatGroup> groups;

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public Long getAdId() {
        return adId;
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Boolean getIsBookGroup() {
        return isBookGroup;
    }

    public void setIsBookGroup(Boolean isBookGroup) {
        this.isBookGroup = isBookGroup;
    }

    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    public Long getQrcodeId() {
        return qrcodeId;
    }

    public void setQrcodeId(Long qrcodeId) {
        this.qrcodeId = qrcodeId;
    }

    public Date getDistributionTime() {
        return distributionTime;
    }

    public void setDistributionTime(Date distributionTime) {
        this.distributionTime = distributionTime;
    }

    public List<BookAdviser> getBooks() {
        return books;
    }

    public void setBooks(List<BookAdviser> books) {
        this.books = books;
    }

    public List<DistributionWechatGroup> getGroups() {
        return groups;
    }

    public void setGroups(List<DistributionWechatGroup> groups) {
        this.groups = groups;
    }

    @Override
    public String toString() {
        return "AdvertisingDistributionBook{" +
                "id=" + id +
                ", adId=" + adId +
                ", bookId=" + bookId +
                ", adviserId=" + adviserId +
                ", agentId=" + agentId +
                ", channelId=" + channelId +
                ", isBookGroup=" + isBookGroup +
                ", classifyId=" + classifyId +
                ", qrcodeId=" + qrcodeId +
                ", distributionTime=" + distributionTime +
                ", books=" + books +
                ", groups=" + groups +
                "} " + super.toString();
    }
}