package com.pcloud.book.appeal.biz;

import java.util.List;

import com.pcloud.book.appeal.dto.AppealAdviserDto;
import com.pcloud.book.appeal.dto.BookAppealResultDto;
import com.pcloud.book.appeal.dto.BookAppealDto;
import com.pcloud.book.appeal.entity.BookAppeal;
import com.pcloud.book.book.dto.BookMainAdviserDto;
import com.pcloud.common.page.PageBean;
import com.pcloud.common.page.PageParam;

/**
 * 书刊申诉业务处理接口
 * 
 * @author:lili
 * @date 创建时间：2017年3月30日 下午3:41:30
 * @version 1.0
 * @return
 */
public interface BookAppealBiz {

	/**
	 * 书刊申诉
	 * 
	 * @param bookAppeal
	 *            书刊申诉实体类
	 */
	void create(BookAppeal bookAppeal);

	/**
	 * 申诉列表
	 * 
	 * @param pageParam
	 *            分页参数传递工具类
	 * @param bookName
	 *            图书名称
	 * @param appealState
	 *            申诉状态
	 * @return
	 */
	PageBean list(PageParam pageParam, String bookName, Integer appealState);

	/**
	 * 获取申诉详情
	 * 
	 * @param bookAppealId
	 *            图书申诉标识
	 * @return
	 */
	BookAppealDto getById(Long bookAppealId);

	/**
	 * 申诉审核
	 * 
	 * @param bookAppeal
	 *            书刊申诉实体类
	 */
	void setupAudit(BookAppeal bookAppeal);

	/**
	 * 
	 * @param bookAppealId
	 *            图书申诉标识
	 * @return List<BookAppealDto>
	 */
	List<AppealAdviserDto> getAppealAdvisers(Long bookAppealId);

	/**
	 * 
	 * @param auditUser
	 *            审核人
	 * @param bookMainAdviserDto
	 *            设置主编辑Dto
	 */
	void setMainAdviser(Long auditUser, BookMainAdviserDto bookMainAdviserDto);

	/**
	 * 获取申诉结果
	 * 
	 * @param bookAppealId
	 *            图书申诉标识
	 * @return
	 */
	List<BookAppealResultDto> getAppealResult(Long bookAppealId);

}
