/**
 * 
 */
package com.pcloud.book.book.biz;

import java.util.List;

import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.book.dto.BookResourceDto;
import com.pcloud.book.book.entity.BookResource;
import com.pcloud.common.exceptions.BizException;

/**
 * @描述：
 * 
 * @作者：lili
 * @创建时间：2017年3月17日,下午3:58:54 @版本：1.0
 */
public interface BookResourceBiz {

	/**
	 * 添加书籍资源关联关系
	 * 
	 * @param bookResource
	 *            图书资源信息
	 * @throws BizException
	 */
	public void create(BookResource bookResource) throws BizException;

	/**
	 * 删除资源应用关联关系
	 * 
	 * @param bookResourceId
	 *            图书资源关联标识
	 * @return
	 */
	public void delete(Long bookResourceId) throws BizException;

	/**
	 * 书籍标识删除书籍资源关联关系
	 * 
	 * @param bookId
	 *            图书标识
	 * @throws BizException
	 */
	public void deleteByBook(Long bookId) throws BizException;

	/**
	 * 批量删除作品资源关联关系
	 * 
	 * @param bookIds
	 *            图书标识列表
	 * @throws BizException
	 */
	public void deleteByBooks(List<Long> bookIds) throws BizException;

	/**
	 * 获取书籍关联的资源
	 * 
	 * @param bookId
	 *            图书标识
	 * @param adviserId
	 *            编辑标识
	 * @param channelId
	 *            渠道标识
	 * @return
	 */
	public List<BookResourceDto> getListById(Long bookId, Long adviserId, Long channelId) throws BizException;

	/**
	 * 根据书籍和渠道删除书籍资源关联信息
	 * 
	 * @param bookId
	 *            图书标识
	 * @param channelId
	 *            渠道标识
	 * @return
	 */
	public void deleteByBookAndChannel(Long bookId, Long channelId) throws BizException;

	/**
	 * 获取书籍关联资源与作品
	 * 
	 * @param bookId
	 *            图书标识
	 * @param adviserId
	 *            编辑标识
	 * @param channelId
	 *            渠道标识
	 * @return
	 */
	public BookDto getResouceByBook(Long bookId, Long adviserId, Long channelId);

	/**
	 * 获取书籍关联资源（不含资源基本信息）
	 * 
	 * @param bookId
	 *            图书标识
	 * @param adviserId
	 *            编辑标识
	 * @param channelId
	 *            渠道标识
	 * @return
	 * @throws BizException
	 */
	List<BookResourceDto> listBaseById(Long bookId, Long adviserId, Long channelId) throws BizException;

	/**
	 * 获取图书关联资源个数
	 * 
	 * @param adviserId
	 *            编辑标识
	 * @param bookId
	 *            图书标识
	 * @param channelId
	 *            渠道标识
	 * @return
	 */
	public Integer getResourceCount(Long adviserId, Long bookId, Long channelId);

	/**
	 * 获取图书关联资源文件
	 * 
	 * @param adviserId
	 *            编辑标识
	 * @param bookId
	 *            图书标识
	 * @param channelId
	 *            渠道标识
	 * @return
	 * @throws BizException
	 */
	List<BookResourceDto> listById4Agent(Long bookId, Long adviserId, Long channelId) throws BizException;

	/**
	 * 获取资源关联的图书
	 * 
	 * @param resourceId
	 *            资源标识
	 * @return
	 */
	public List<Long> listByResourceId(Long resourceId);

}
