package com.pcloud.book.book.cache;

import org.springframework.stereotype.Component;

import com.pcloud.book.book.constant.BookConstant;
import com.pcloud.book.book.dto.BookDto;
import com.pcloud.common.utils.cache.redis.JedisClusterUtils;
import com.pcloud.common.utils.string.StringUtil;

/** 
  * 描述  :图书缓存数据
  * @author 作者: lili
  * @date 创建时间：2017年6月15日 下午2:48:34 
  * @version 1.0 
  */
@Component("bookCache")
public class BookCache {

	/**
	 * 图书基本信息
	 * @param BookDto
	 */
	public void setBookToRedis(BookDto bookDto){
		if (null != bookDto) {
			StringBuffer key = new StringBuffer(BookConstant.BOOK_CACHE);
			key.append(bookDto.getBookId());
			JedisClusterUtils.setJson(key.toString(), bookDto,BookConstant.BOOK_CACHE_SECOUND);
		}
	}
	
	/**
	 * 获取图书基本信息
	 * @param bookId 图书标识
	 * @return
	 */
	public BookDto getBookToRedis(Long bookId){
		StringBuffer key = new StringBuffer(BookConstant.BOOK_CACHE);
		key.append(bookId); 
		return JedisClusterUtils.getJson(key.toString(), BookDto.class);
	}
	
	/** 
	 * 图书基本信息
	 * @param BookDto
	 */
	public void setBookToRedisByIsbn(BookDto bookDto){
		if (null != bookDto) {
			StringBuffer key = new StringBuffer(BookConstant.BOOK_ISBN_CACHE);
			key.append(bookDto.getIsbn());
			if(!StringUtil.isEmpty(bookDto.getSerialNumber())){
				key.append("/"+bookDto.getSerialNumber());
			}
			JedisClusterUtils.setJson(key.toString(), bookDto,BookConstant.BOOK_CACHE_SECOUND);
		}
	}
	
	/**
	 * 图书基本信息
	 * @param BookDto
	 */
	public BookDto getBookToRedisByIsbn(String isbn,String serialNumber) {
		StringBuffer key = new StringBuffer(BookConstant.BOOK_ISBN_CACHE);
		key.append(isbn);
		if(!StringUtil.isEmpty(serialNumber)){
			key.append("/"+serialNumber);
		}
		return JedisClusterUtils.getJson(key.toString(), BookDto.class);
	}
	
	/**
	 * 清除redis中图书数据
	 * @param bookId
	 * @param isbn
	 * @return
	 */
	public void clearRedisByBook(Long bookId,String isbn,String serialNumber) {
		StringBuffer key = new StringBuffer(BookConstant.BOOK_CACHE);
		key.append(bookId);
		StringBuffer isbnKey = new StringBuffer(BookConstant.BOOK_ISBN_CACHE);
		isbnKey.append(isbn);
		if(!StringUtil.isEmpty(serialNumber)){
			isbnKey.append("/"+serialNumber);
		}
		JedisClusterUtils.del(key.toString());
		JedisClusterUtils.del(isbnKey.toString());
	}
	
	/**
	 * 设置书籍总数信息
	 * @param bookCount
	 */
	public void setBookCountToRedis(Integer bookCount){
		if (null != bookCount) {
			StringBuffer key = new StringBuffer(BookConstant.BOOK_CACHE);
			key.append("PLATFORM_BOOK_COUNT");
			JedisClusterUtils.setJson(key.toString(), bookCount,BookConstant.BOOK_CACHE_SECOUND);
		}
	}
	
	/**
	 * 获取书籍总数信息
	 * @return
	 */
	public Integer getBookCountToRedis(){
		StringBuffer key = new StringBuffer(BookConstant.BOOK_CACHE);
		key.append("PLATFORM_BOOK_COUNT"); 
		return JedisClusterUtils.getJson(key.toString(), Integer.class);
	}
	
	/**
	 * 清除书籍总数缓存信息
	 * @return
	 */
	public void delBookCountToRedis(){
		StringBuffer key = new StringBuffer(BookConstant.BOOK_CACHE);
		key.append("PLATFORM_BOOK_COUNT"); 
		JedisClusterUtils.del(key.toString());
	}
	
	/**
	 * 缓存值自减1
	 * @param key
	 * @return
	 */
	public Long incrObject(String key) {
		return JedisClusterUtils.incr(key);
	}
	
	/**
	 * 缓存值自减1
	 * @param key
	 * @return
	 */
	public Long decrObject(String key) {
		return JedisClusterUtils.decr(key);
	}

	
}
