package com.pcloud.book.book.dao.impl;

import com.google.common.collect.Maps;
import com.pcloud.book.book.dao.BookFreezeDao;
import com.pcloud.book.book.dto.BookFreezeDto;
import com.pcloud.book.book.entity.BookFreeze;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 图书冻结数据访问层实现
 * 
 * @author lili
 * @date 2018/1/18 18:18
 */
@Component("bookFreezeDao")
public class BookFreezeDaoImpl extends BaseDaoImpl<BookFreeze> implements BookFreezeDao {

	@Override
	public Boolean isFreeze(Long bookId) {
		return this.getSqlSession().selectOne(this.getStatement("isFreeze"), bookId);
	}

	@Override
	public Map<Long, BookFreezeDto> getFreezeStatus(List<Long> bookIds) {
		return this.getSqlSession().selectMap(this.getStatement("getFreezeStatus"), bookIds, "bookId");
	}

	/**
	 * 获取冻结信息
	 */
	@Override
	public BookFreezeDto getBaseById(Long bookId) {
		return this.getSqlSession().selectOne(super.getStatement("getBaseById"), bookId);
	}

	/**
	 * 解冻收益(没有被基金购买)
	 */
	@Override
	public void thaw(Long bookFundId,Long bookId, Long partyId) {
		Map<String, Object> paramMap = Maps.newHashMap();
		paramMap.put("bookId", bookId);
		paramMap.put("partyId", partyId);
		if(null != bookFundId){
			paramMap.put("bookFundId", bookFundId);
		}
		this.getSqlSession().update(this.getStatement("thaw"), paramMap);
	}

	@Override
	public Map<Long, BookFreezeDto> getIsFreeze(List<Long> bookIds) {
		return this.getSqlSession().selectMap(this.getStatement("getIsFreeze"), bookIds, "bookId");
	}

	/**
	 * 该书刊当前和以后基金冻结信息
	 */
	@Override
	public List<BookFreezeDto> getFreezeInfo(Long bookId) {
		return this.getSqlSession().selectList(this.getStatement("getFreezeInfo"), bookId);
	}

	/**
	 * 批量获取书刊当前和以后基金冻结信息
	 */
	@Override
	public List<BookFreezeDto> listFreezeInfo(List<Long> bookIds) {
		return this.getSqlSession().selectList(this.getStatement("listFreezeInfo"), bookIds);
	}

	@Override
	public BookFreezeDto getInfoById(Long bookId) {
		return this.getSqlSession().selectOne(this.getStatement("getInfoById"),bookId);
	}
}
