/**
 * 
 */
package com.pcloud.book.book.dao.impl;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import com.pcloud.book.book.dao.BookResourceDao;
import com.pcloud.book.book.dto.BookResourceDto;
import com.pcloud.book.book.entity.BookResource;
import com.pcloud.common.core.dao.BaseDaoImpl;

/**
 * @描述：书籍资源数据访问层接口实现类
 * @作者：lili
 * @创建时间：2017年3月17日,下午3:57:10
 * @版本：1.0
 */
@Repository("bookResourceDao")
public class BookResourceDaoImpl extends BaseDaoImpl<BookResource> implements BookResourceDao {

	/**
	 * 删除书籍资源关联关系
	 */
	@Override
	public long deleteByBook(Long bookId) {
		return super.getSqlSession().delete(super.getStatement("deleteByBook"), bookId);
	}
	
	/**
	 * 批量删除资源关联关系
	 */
	@Override
	public long deleteByBooks(List<Long> bookIds) {
		return super.getSqlSession().delete(super.getStatement("deleteByBooks"), bookIds);
	}
	
	/**
	 * 获取书籍关联的资源
	 */
	@Override
	public List<BookResourceDto> getListById(BookResource bookResource) {
		return super.getSqlSession().selectList(super.getStatement("getListById"), bookResource);
	}
	
	/**
	 * 根据书籍和渠道删除书籍资源关联信息
	 */
	@Override
	public Integer deleteByBookAndChannel(Map<String, Object> paramMap) {
		
		return super.getSqlSession().delete(super.getStatement("deleteByBookAndChannel"), paramMap);
		
	}

	/**
	 * 获取图书资源关联根据图书资源标识
	 */
	@Override
	public BookResourceDto getByBookResourceId(Long bookResourceId) {
		return super.getSqlSession().selectOne(super.getStatement("getByBookResourceId"), bookResourceId);
	}

	/**
	 * 根据资源标识获取图书资源关联关系
	 */
	@Override
	public List<BookResourceDto> listBookByResource(Long resourceId) {
		return super.getSqlSession().selectList(super.getStatement("listBookByResource"), resourceId);
	}

	/**
	 * 获取图书关联资源个数
	 */
	@Override
	public Integer getResourceCount(Map<String, Object> paramMap) {
		return super.getSqlSession().selectOne(super.getStatement("getResourceCount"), paramMap);
	}

	/**
	 * 获取资源关联的图书
	 */
	@Override
	public List<Long> listByResourceId(Long resourceId) {
		return super.getSqlSession().selectList(this.getStatement("listByResourceId"),resourceId);
	}

}
