/**
 * 
 */
package com.pcloud.book.book.dao.impl;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import com.pcloud.book.book.dao.BookTypeDao;
import com.pcloud.book.book.dto.BookTypeDto;
import com.pcloud.book.book.entity.BookType;
import com.pcloud.common.core.dao.BaseDaoImpl;

/**
 * @描述：
 * @作者：songx
 * @创建时间：2017年1月3日,下午3:09:08
 * @版本：1.0
 */
@Repository("bookTypeDao")
public class BookTypeDaoImpl extends BaseDaoImpl<BookType> implements BookTypeDao {

	/**
	 * 获取类型列表
	 */
	@Override
	public List<BookTypeDto> getList() {
		return super.getSqlSession().selectList(super.getStatement("getList"));
	}

	/**
	 * 图书和期刊占比
	 */
	@Override
	public List<BookTypeDto> getPercent4Type(Long adviserId) {
		return super.getSqlSession().selectList(super.getStatement("getPercent4Type"), adviserId);
	}

	/**
	 * 获取图书类型Map关联
	 */
	@Override
	public Map<String, BookTypeDto> getTypeCodeMap() {
		
		return super.getSqlSession().selectMap(super.getStatement("getTypeCodeMap"),"typeCode");
	}

}
