package com.pcloud.book.book.vo;

import com.google.common.collect.Lists;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.pcloud.book.book.entity.KeywordWarehouseDetail;
import com.pcloud.common.utils.BeanUtils;

import org.springframework.util.CollectionUtils;

import java.util.List;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

@Data
@ToString
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BookKeywordProductVO {

    @ApiModelProperty("关键词id")
    private Long keywordId;

    @ApiModelProperty("关键词")
    private String keyword;

    @ApiModelProperty("关键词详情id")
    private Long keywordDetailId;

    @ApiModelProperty("匹配规则")
    private Integer matchingRule;

    @ApiModelProperty("作品/应用id")
    private Long productId;

    @ApiModelProperty("作品/应用类型（1：商品2：应用）")
    private String productType;

    @ApiModelProperty("渠道id")
    private Long channelId;

    @ApiModelProperty("作品/应用图片")
    private String picUrl;

    @ApiModelProperty("作品/应用链接")
    private String linkUrl;

    @ApiModelProperty("作品/应用标题")
    private String title;

    @ApiModelProperty("作品/应用描述")
    private String description;

    @ApiModelProperty("关键词引导语")
    private String guide;

    @ApiModelProperty("作品/应用内容")
    private String content;

    @ApiModelProperty("应用类型")
    private String typeCode;

    @ApiModelProperty("专业标签id")
    private Long professionalLabelId;

    @ApiModelProperty("深度标签id")
    private Long depthLabelId;

    @ApiModelProperty("目的标签")
    private Long purposeLabelId;

    @ApiModelProperty("使用次数")
    private Integer useNum;

    @ApiModelProperty("是否标记（1：是 0：否）")
    private Integer isMark;

    public static List<BookKeywordProductVO> cloneByEntity(List<KeywordWarehouseDetail> list){
        if(CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        List<BookKeywordProductVO> vos = Lists.newArrayList();
        for (KeywordWarehouseDetail detail : list) {
            BookKeywordProductVO vo = new BookKeywordProductVO();
            BeanUtils.copyProperties(detail, vo);
            vos.add(vo);
        }
        return vos;
    }


}
