package com.pcloud.book.consumer.voicemessage;

import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.pcloud.channelcenter.base.exceptions.ChannelBizException;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.voicemessage.party.merchant.entity.MerchantVideo;
import com.pcloud.voicemessage.party.merchant.service.MerchantVideoService;

/** 
  * 描述  :作者录音中间件
  * @author 作者: lili
  * @date 创建时间：2017年6月12日 下午5:10:52 
  * @version 1.0 
  */
@Component("merchantVideoConsr")
public class MerchantVideoConsr {

	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(MerchantVideoConsr.class);
	
	
	@Autowired
	private MerchantVideoService merchantVideoService;

	/**
	 * 获取录音
	 * 
	 * @param merchatId
	 * @return
	 * @throws BizException
	 */
	public Map<Long, MerchantVideo> getVideoByObjectId(List<Long> ids, String objectDescribe) throws BizException {
		LOGGER.info("获取录音,参数列表[ids]:" + ids + "objectDescribe=" + objectDescribe);
		if (ListUtils.isEmpty(ids) || objectDescribe == null) {
			return null;
		}
		try {
			return ResponseHandleUtil.parseMapResponse(merchantVideoService.getVideoByObjectId(ids, objectDescribe), Long.class, MerchantVideo.class);
		} catch (BizException e) {
			LOGGER.warn("获取录音失败:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("获取录音失败:" + e.getMessage(), e);
			throw new ChannelBizException(ChannelBizException.INVOKE_USER_ERROR, "获取录音信息失败~!");
		}
	}

	/**
	 * 获取录音
	 * 
	 * @param merchatId
	 * @return
	 * @throws BizException
	 */
	public Map<Long, MerchantVideo> getVideoById(List<Long> soundIds) throws BizException {
		LOGGER.info("获取录音,参数列表[soundIds]:" + soundIds);
		if (ListUtils.isEmpty(soundIds)) {
			return null;
		}
		try {
			return	ResponseHandleUtil.parseMapResponse(merchantVideoService.getVideoById(soundIds), Long.class, MerchantVideo.class);
		} catch (BizException e) {
			LOGGER.warn("获取录音失败:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("获取录音失败:" + e.getMessage(), e);
			throw new ChannelBizException(ChannelBizException.INVOKE_USER_ERROR, "获取录音信息失败~!");
		}
	}
	
}
