package com.pcloud.book.copyright.dao;

import com.pcloud.book.copyright.dto.ServeDTO;
import com.pcloud.book.copyright.entity.BookAuthServe;
import com.pcloud.book.copyright.vo.ServeVO;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @author lily
 * @date 2018/12/3 14:17
 */
public interface BookAuthServeDao extends BaseDao<BookAuthServe> {

    /**
     *  删除授权服务
     */
    void deleteServes(List<Long> ids);

    /**
     * 是否设置授权应用
     * @return
     */
    List<ServeDTO> isSetServeAuth(Long bookId, Long channelId, Long adviserId, List<Long> serveIds);

    /**
     * 加入正版授权得服务
     */
    List<ServeVO> listServesByBook(Long bookId, Long channelId, Long adviserId);

    /**
     * 校验服务是否需要授权
     */
    Boolean checkIsNeedAuth(Long bookId, Long channelId, Long adviserId, Long serveId, String serveType);

    /**
     * 获取需要删除的数据
     */
    List<Long> selectNeedDelete(Long bookId, Long channelId, Long adviserId);
}
