package com.pcloud.book.copyright.facade.impl;

import com.pcloud.book.copyright.biz.BookAuthCodeBiz;
import com.pcloud.book.copyright.facade.BookAuthCodeFacade;
import com.pcloud.book.copyright.vo.CheckCodeParam;
import com.pcloud.book.copyright.vo.CheckIsAuthServeParam;
import com.pcloud.book.copyright.vo.CodeUseStatusVO;
import com.pcloud.book.copyright.vo.FileVO;
import com.pcloud.book.copyright.vo.ImportRecordVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author lily
 * @date 2018/11/29 16:59
 */
@RequestMapping("bookAuthCode")
@RestController("bookAuthCodeFacade")
public class BookAuthCodeFacadeImpl implements BookAuthCodeFacade {

    @Autowired
    private BookAuthCodeBiz bookAuthCodeBiz;

    @Override
    @RequestMapping(value = "checkCode", method = RequestMethod.POST)
    public ResponseDto<CodeUseStatusVO> checkCode(@CookieValue("userInfo") String userInfo, @RequestBody CheckCodeParam checkCodeParam) throws PermissionException, BizException {
        Long channelId = checkCodeParam.getChannelId();
        if(channelId == null){
            channelId = Cookie.getId(userInfo, Cookie._CHANNEL_ID);
        }
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        Integer codeUseStatus = bookAuthCodeBiz.checkCode(checkCodeParam, channelId, wechatUserId);
        CodeUseStatusVO codeUseStatusVO = new CodeUseStatusVO();
        codeUseStatusVO.setCodeUseStatus(codeUseStatus);
        return new ResponseDto<>(codeUseStatusVO);
    }

    @Override
    @PostMapping("checkServe")
    public ResponseDto<Boolean> checkServe(@CookieValue("userInfo") String userInfo, @RequestBody CheckIsAuthServeParam checkIsAuthServeParam) throws PermissionException, BizException {
        Long channelId = checkIsAuthServeParam.getChannelId();
        if(channelId == null){
            channelId = Cookie.getId(userInfo, Cookie._CHANNEL_ID);
        }
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        Boolean code = bookAuthCodeBiz.checkServe(checkIsAuthServeParam, channelId, wechatUserId);
        return new ResponseDto<>(code == null ? false : code);
    }

    @Override
    @PostMapping("importCode")
    public ResponseDto<?> importCode(@RequestHeader("token") String token, @RequestBody FileVO fileVO) throws PermissionException, BizException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookAuthCodeBiz.importCode(fileVO, adviserId);
        return  new ResponseDto<>();
    }

    @Override
    @GetMapping("importCodeRecord")
    public ResponseDto<PageBeanNew<ImportRecordVO>> importCodeRecord(@RequestHeader("token")String token, @RequestParam("bookId") Long bookId, @RequestParam("channelId") Long channelId, @RequestParam("currentPage") Integer currenPage, @RequestParam("numPerPage") Integer numPerPage) throws PermissionException, BizException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        PageBeanNew<ImportRecordVO> pageBean = bookAuthCodeBiz.importCodeRecord(bookId, channelId, adviserId, currenPage, numPerPage);
        return new ResponseDto<>(pageBean);
    }
}
