package com.pcloud.book.copyright.vo;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author lily
 * @date 2018/12/3 11:26
 */
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class SetAuthOpenParam implements Serializable {

    @ApiModelProperty("图书标识")
    private Long bookId;

    @ApiModelProperty("运营标识")
    private Long channelId;

    @ApiModelProperty("价格")
    private BigDecimal price;

    @ApiModelProperty("编码可使用次数")
    private Integer codeUseCount;

    @ApiModelProperty("生成码个数")
    private Integer codeCount;

    @ApiModelProperty("购买链接地址")
    private String buyUrl;

    @ApiModelProperty("图书状态")
    private Integer bookStatus;

    @ApiModelProperty("验证类型")
    private Integer checkType;

    @ApiModelProperty("服务")
    private List<ServeVO> serves;

    @ApiModelProperty("是否包含条形码")
    private Integer isHaveBarCode;

    public List<ServeVO> getServes() {
        return serves;
    }

    public void setServes(List<ServeVO> serves) {
        this.serves = serves;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Integer getBookStatus() {
        return bookStatus;
    }

    public void setBookStatus(Integer bookStatus) {
        this.bookStatus = bookStatus;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Integer getCodeUseCount() {
        return codeUseCount;
    }

    public void setCodeUseCount(Integer codeUseCount) {
        this.codeUseCount = codeUseCount;
    }

    public Integer getCodeCount() {
        return codeCount;
    }

    public void setCodeCount(Integer codeCount) {
        this.codeCount = codeCount;
    }

    public String getBuyUrl() {
        return buyUrl;
    }

    public void setBuyUrl(String buyUrl) {
        this.buyUrl = buyUrl;
    }

    public Integer getCheckType() {
        return checkType;
    }

    public void setCheckType(Integer checkType) {
        this.checkType = checkType;
    }

    public Integer getIsHaveBarCode() {
        return isHaveBarCode;
    }

    public void setIsHaveBarCode(Integer isHaveBarCode) {
        this.isHaveBarCode = isHaveBarCode;
    }

    @Override
    public String toString() {
        return "SetAuthOpenVO{" +
                "bookId=" + bookId +
                ", channelId=" + channelId +
                ", price=" + price +
                ", codeUseCount=" + codeUseCount +
                ", codeCount=" + codeCount +
                ", buyUrl='" + buyUrl + '\'' +
                ", bookStatus=" + bookStatus +
                ", checkType=" + checkType +
                ", serves=" + serves +
                '}';
    }
}
