package com.pcloud.book.group.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class AdGroupQrcodeDTO implements Serializable {

    private static final long serialVersionUID = 3234046973249447114L;

    /**
     * 群二维码标识
     */
    private Long groupQrcodeId;

    /**
     * 分类标识
     */
    private Long classifyId;

    /**
     * 微信群名称
     */
    private String groupQrcodeName;

    /**
     * 书刊ID
     */
    private Long bookId;

    /**
     * 书刊名称
     */
    private String bookName;

    /**
     * ISBN
     */
    private String isbn;

    /**
     * 分类名称
     */
    private String classify;

    /**
     * 运营ID
     */
    private Long channelId;

    /**
     * 编辑ID
     */
    private Long adviserId;

    /**
     * 编辑名称
     */
    private String adviserName;

    /**
     * 出版社ID
     */
    private Long agentId;

    /**
     * 出版社名称
     */
    private String agentName;

    /**
     * 曝光量
     */
    private Long exposureNum;

    /**
     * 点击量
     */
    private Long clickNum;

    /**
     * 点击读者量
     */
    private Long clickUserNum;

    /**
     * 广告位数量
     */
    private Long advertisingSpaceNum;

    /**
     * 点击率
     */
    private BigDecimal clickRate;

    /**
     * 累计收益
     */
    private BigDecimal totalIncome;

    /**
     * 是否开启广告位权限
     */
    private Boolean isOpen;

    /**
     * 投放时间
     */
    private Date distributionTime;
    /**
     * 报名量
     */
    private Long registerNum;
    /**
     * 报名率
     */
    private BigDecimal registerRate;

    public Long getGroupQrcodeId() {
        return groupQrcodeId;
    }

    public void setGroupQrcodeId(Long groupQrcodeId) {
        this.groupQrcodeId = groupQrcodeId;
    }

    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    public String getGroupQrcodeName() {
        return groupQrcodeName;
    }

    public void setGroupQrcodeName(String groupQrcodeName) {
        this.groupQrcodeName = groupQrcodeName;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public String getBookName() {
        return bookName;
    }

    public void setBookName(String bookName) {
        this.bookName = bookName;
    }

    public String getIsbn() {
        return isbn;
    }

    public void setIsbn(String isbn) {
        this.isbn = isbn;
    }

    public String getClassify() {
        return classify;
    }

    public void setClassify(String classify) {
        this.classify = classify;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    public String getAdviserName() {
        return adviserName;
    }

    public void setAdviserName(String adviserName) {
        this.adviserName = adviserName;
    }

    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public Long getExposureNum() {
        return exposureNum;
    }

    public void setExposureNum(Long exposureNum) {
        this.exposureNum = exposureNum;
    }

    public Long getClickNum() {
        return clickNum;
    }

    public void setClickNum(Long clickNum) {
        this.clickNum = clickNum;
    }

    public Long getAdvertisingSpaceNum() {
        return advertisingSpaceNum;
    }

    public void setAdvertisingSpaceNum(Long advertisingSpaceNum) {
        this.advertisingSpaceNum = advertisingSpaceNum;
    }

    public BigDecimal getClickRate() {
        return clickRate;
    }

    public void setClickRate(BigDecimal clickRate) {
        this.clickRate = clickRate;
    }

    public BigDecimal getTotalIncome() {
        return totalIncome;
    }

    public void setTotalIncome(BigDecimal totalIncome) {
        this.totalIncome = totalIncome;
    }

    public Boolean getIsOpen() {
        return isOpen;
    }

    public void setIsOpen(Boolean isOpen) {
        this.isOpen = isOpen;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getDistributionTime() {
        return distributionTime;
    }

    public void setDistributionTime(Date distributionTime) {
        this.distributionTime = distributionTime;
    }

    public Long getClickUserNum() {
        return clickUserNum;
    }

    public void setClickUserNum(Long clickUserNum) {
        this.clickUserNum = clickUserNum;
    }

    public Long getRegisterNum() {
        return registerNum;
    }

    public void setRegisterNum(Long registerNum) {
        this.registerNum = registerNum;
    }

    public BigDecimal getRegisterRate() {
        return registerRate;
    }

    public void setRegisterRate(BigDecimal registerRate) {
        this.registerRate = registerRate;
    }

    @Override
    public String toString() {
        return "AdGroupQrcodeDTO{" +
                "groupQrcodeId=" + groupQrcodeId +
                ", classifyId=" + classifyId +
                ", groupQrcodeName='" + groupQrcodeName + '\'' +
                ", bookId=" + bookId +
                ", bookName='" + bookName + '\'' +
                ", isbn='" + isbn + '\'' +
                ", classify='" + classify + '\'' +
                ", channelId=" + channelId +
                ", adviserId=" + adviserId +
                ", adviserName='" + adviserName + '\'' +
                ", agentId=" + agentId +
                ", agentName='" + agentName + '\'' +
                ", exposureNum=" + exposureNum +
                ", clickNum=" + clickNum +
                ", clickUserNum=" + clickUserNum +
                ", advertisingSpaceNum=" + advertisingSpaceNum +
                ", clickRate=" + clickRate +
                ", totalIncome=" + totalIncome +
                ", isOpen=" + isOpen +
                ", distributionTime=" + distributionTime +
                ", registerNum=" + registerNum +
                ", registerRate=" + registerRate +
                '}';
    }
}
