package com.pcloud.book.keywords.vo;

import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author lily
 * @date 2019/4/25 10:17
 */
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ListKeywordVO implements Serializable {

    private static final long serialVersionUID = -4077837341410058443L;
    @ApiModelProperty("设置关键词标识")
    private Long bookKeywordId;

    @ApiModelProperty("关键词标识")
    private Long keywordId;

    @ApiModelProperty("关键词")
    private String keywords;

    @ApiModelProperty("引导语")
    private String guide;

    @ApiModelProperty("匹配规则")
    private Integer matchingRule;

    @ApiModelProperty("是否仓库词（1：是  0：否）")
    private Integer isWarehouse;

    @ApiModelProperty("仓库关键词id")
    private Long warehouseId;

    @ApiModelProperty("回复类型")
    private Integer replyType;

    @ApiModelProperty("服务标识")
    private Long serveId;

    @ApiModelProperty("服务类型")
    private String serveType;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("图片地址")
    private String picUrl;

    @ApiModelProperty("链接地址")
    private String linkUrl;

    @ApiModelProperty("描述信息")
    private String description;

    @ApiModelProperty("排序")
    private Integer rank;

    @ApiModelProperty("分类id")
    private Long classifyId;

    @ApiModelProperty("销售价")
    private Double retailPrice;

    @ApiModelProperty("协议价")
    private Double dealPrice;

    @ApiModelProperty("协议价")
    private Long channelId;

    @ApiModelProperty("应用或作品类型")
    private String typeCode;

    @ApiModelProperty("来源APP应用，PRODUCT作品，SUPER_PRODUCT超级作者作品")
    private String apSource;

}
