package com.pcloud.book.mq.topic;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.group.biz.BookClassifyBuyRecordBiz;
import com.pcloud.book.group.entity.BookClassifyBuyRecord;
import com.pcloud.book.mq.config.MQTopicConumer;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.constant.ProductTypeConstant;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.facade.tradecenter.dto.OrderItemTopicDto;
import com.pcloud.facade.tradecenter.dto.OrderTopicDto;
import com.pcloud.facade.tradecenter.service.OrderFormService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Component
@RabbitListener(queues = MQTopicConumer.PAYMENT)
public class PayMentListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(PayMentListener.class);

    @Autowired
    private BookClassifyBuyRecordBiz bookClassifyBuyRecordBiz;
    @Autowired
    private OrderFormService orderFormService;

    /**
     * 接收交易中心支付消息
     */
    @ParamLog("监听交易完成消息消息")
    @RabbitHandler
    public void onMessage(OrderTopicDto dto) throws BizException {
        LOGGER.info("【接收交易中心支付消息】[Message]={}", dto);
        if (dto == null || dto.getOrderNum() == null) {
            LOGGER.error("【接收支付信息】订单为空,<ERROR>.[orderNum]={}", dto.getOrderNum());
            throw new BookBizException(BookBizException.CONSUMER_TOPIC_ERROR, "订单为空");
        }
        // 判断是不是群分类作品,如果不是跳过不处理
        List<OrderItemTopicDto> itemList = dto.getItemList();
        if (CollectionUtils.isEmpty(itemList)) {
            LOGGER.info("【接收支付信息】不是有效的作品订单消息,<ERROR>");
            return;
        }
        OrderItemTopicDto orderItemTopicDto = itemList.get(0);
        if (!ProductTypeConstant.BOOK_GROUP.equals(orderItemTopicDto.getProductTypeCode())) {
            LOGGER.info("【接收支付信息】不是有效的群分类作品订单消息,<ERROR>");
            return;
        }
        //  BigDecimal actualPay = dto.getActualPay();
//        if (actualPay == null || actualPay.compareTo(new BigDecimal(0)) < 1){
//            return;
//        }
        try {
            BookClassifyBuyRecord bookClassifyBuyRecord = new BookClassifyBuyRecord();
            bookClassifyBuyRecord.setProductId(orderItemTopicDto.getProductId());
            bookClassifyBuyRecord.setProductSpecId(orderItemTopicDto.getSpecificationId());
            bookClassifyBuyRecord.setOrderNumber(dto.getOrderNum());
            bookClassifyBuyRecord.setWechatUserId(dto.getCustomerId());
            bookClassifyBuyRecord.setPrice(dto.getActualPay());
            // 创建订单支付记录
            try {
                bookClassifyBuyRecordBiz.insertRecord(bookClassifyBuyRecord);
            } catch (DataIntegrityViolationException e) {
                LOGGER.warn("已购买" + bookClassifyBuyRecord);
            }
        } catch (Exception e) {
            LOGGER.error("支付消息监听失败+" + e.getMessage(), e);
        }

    }
}
