package com.pcloud.book.mq.topic;

import com.pcloud.book.group.dto.PushAddUserMessageDTO;
import com.pcloud.book.keywords.biz.BookGuideBiz;
import com.pcloud.book.mq.config.MQTopicConumer;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author lily
 * @date 2019/5/8 14:55
 */
@RabbitListener(queues = MQTopicConumer.PUSH_ADD_USER_MESSAGE)
@Component
public class PushAddUserMessageListemer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PushAddUserMessageListemer.class);


    @Autowired
    private BookGuideBiz bookGuideBiz;

    /**
     * 发送欢迎语消息
     */
    @ParamLog("发送欢迎语消息")
    @RabbitHandler
    public void onMessage(PushAddUserMessageDTO pushAddUserMessageDTO) throws BizException {
        try {
            long time = System.currentTimeMillis() - pushAddUserMessageDTO.getTime();
            if (time < 5000) {
                Thread.sleep(5000 - time);
            }
            bookGuideBiz.sendGuideMessage(pushAddUserMessageDTO);
        } catch (Exception e) {
            LOGGER.error("发送欢迎语消息失败" + e.getMessage(), e);
        }
    }
}
