package com.pcloud.common.core.enums;

import com.pcloud.common.core.constant.ProductTypeConstant;
import com.pcloud.common.utils.string.StringUtil;

/**
 * Description 应用作品类型关联枚举
 * Created by PENG on 2019/3/27.
 */
public enum AppProductTypeEnum {

    KK(AppTypeEnum.KK.value, ProductTypeConstant.LOOK),
    TUTOR(AppTypeEnum.TUTOR.value, ProductTypeConstant.TUTOR),
    GROUP(AppTypeEnum.GROUP.value, ProductTypeConstant.GROUP),
    ZSCORE(AppTypeEnum.ZSCORE.value, ProductTypeConstant.ZSCORE),
    VOTE(AppTypeEnum.VOTE.value, ProductTypeConstant.VOTE),
    CLOCK(AppTypeEnum.CLOCK.value, ProductTypeConstant.CLOCK),
    TEST(AppTypeEnum.TEST.value, ProductTypeConstant.TEST),
    AUDIO(AppTypeEnum.AUDIO.value, ProductTypeConstant.AUDIOAPP),
    ANSWER(AppTypeEnum.ANSWER.value, ProductTypeConstant.ANSWER),
    EF(AppTypeEnum.EF.value, ProductTypeConstant.EF),
    ITEM_BANK(AppTypeEnum.ITEM_BANK.value, ProductTypeConstant.PRETESTAPP),
    QA(AppTypeEnum.QA.value, ProductTypeConstant.QA_APP),
    EBOOK(AppTypeEnum.EBOOK.value, ProductTypeConstant.EBOOK_APP),
    AUDIO_MAGIC(AppTypeEnum.AUDIO_MAGIC.value, ProductTypeConstant.AUDIO_MAGIC),
    TEACH_RESOURCE(AppTypeEnum.TEACH_RESOURCE.value, ProductTypeConstant.TEACH_RESOURCE_APP),
    COURSE_WARE(AppTypeEnum.COURSE_WARE.value, ProductTypeConstant.COURSE_WARE),
    TEST_PAPER(AppTypeEnum.TEST_PAPER.value, ProductTypeConstant.TEST_PAPER_APP),
    MATCH_LISTEN(AppTypeEnum.MATCH_LISTEN.value, ProductTypeConstant.MATCH_LISTEN),
    WORD_DICTATION(AppTypeEnum.WORD_DICTATION.value, ProductTypeConstant.WORD_DICTATION),
    STROKE_ORDER(AppTypeEnum.STROKE_ORDER.value, ProductTypeConstant.STROKE_ORDER_APP),
    IMAGE(AppTypeEnum.IMAGE.value, ProductTypeConstant.IMAGE_APP),
    MEMBER(AppTypeEnum.MEMBER.value, ProductTypeConstant.MEMBER_APP),
    ARTICLE_READING(AppTypeEnum.ARTICLE_READING.value, ProductTypeConstant.ARTICLE_READING),
    ENGLISH_WALKMAN(AppTypeEnum.ENGLISH_WALKMAN.value, ProductTypeConstant.ENGLISH_WALKMAN);

    public final String appTypeCode;

    public final String productTypeCode;

    AppProductTypeEnum(String appTypeCode, String productTypeCode) {
        this.appTypeCode = appTypeCode;
        this.productTypeCode = productTypeCode;
    }

    /**
     * 根据应用类型编码获取作品类型编码
     * @param appTypeCode 应用类型编码
     * @return
     */
    public static String getProductTypeCodeByAppTypeCode(String appTypeCode) {
        if (StringUtil.isEmpty(appTypeCode)) {
            return null;
        }
        AppProductTypeEnum[] var1 = values();
        int var2 = var1.length;
        for (int var3 = 0; var3 < var2; ++var3) {
            AppProductTypeEnum appProductTypeEnum = var1[var3];
            if (appProductTypeEnum.appTypeCode.equals(appTypeCode)) {
                return appProductTypeEnum.productTypeCode;
            }
        }
        return null;
    }

    /**
     * 根据作品类型编码获取应用类型编码
     * @param productTypeCode 作品类型编码
     * @return
     */
    public static String getAppTypeCodeByProductTypeCode(String productTypeCode) {
        if (StringUtil.isEmpty(productTypeCode)) {
            return null;
        }
        AppProductTypeEnum[] var1 = values();
        int var2 = var1.length;
        for (int var3 = 0; var3 < var2; ++var3) {
            AppProductTypeEnum appProductTypeEnum = var1[var3];
            if (appProductTypeEnum.productTypeCode.equals(productTypeCode)) {
                return appProductTypeEnum.appTypeCode;
            }
        }
        return null;
    }
}
