/**
 * @desc 封装上传结果信息
 * @author ma
 * @date 2015年6月15日
 * 
 */
package com.pcloud.common.entity;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;

import io.swagger.annotations.ApiModelProperty;

/**
 * 
 * @描述：
 * 
 * @作者：songx
 * @创建时间：2017年5月17日,下午4:13:55 @版本：1.0
 * 
 *                            modify by songx at 2017-05-17 增加构造方法
 */
public class UploadResultInfo extends BaseEntity {

	/**
	 * 
	 */
	private static final long serialVersionUID = 6731118505525119401L;

	/**
	 * 上传服务器后文件所在组名
	 */
	private String groupName;

	/**
	 * 上传服务器后文件标识，通过该fileid能够下载或续传文件
	 */
	private String fileId;

	/**
	 * 上传信息，一般用来描述异常信息
	 */
	private String message;

	/**
	 * 本次上传大小
	 */
	private Long shardSize;

	/**
	 * 服务器中已存在大小（本机标识已上传文件信息，如果异常中断一般实际服务端文件大小比本机记录的要大）
	 */
	private Long size;

	/**
	 * 是否上传成功
	 */
	@JsonInclude(value = JsonInclude.Include.NON_DEFAULT)
	private Boolean flag = false;

	/**
	 * 文件是否全部上传完成（针对续传而言）
	 */
	@JsonInclude(value = JsonInclude.Include.NON_DEFAULT)
	private Boolean finish = false;

	/**
	 * http下载地址
	 */
	private String url;

	/**
	 * 文件名称
	 */
	private String fileName;

	/**
	 * 文件类型
	 */
	private String fileType;

	/**
	 * 页数
	 */
	private Integer page;

	/**
	 * 对象地址
	 */
	private String objectKey;

	/**
	 * 持续时长
	 */
	private Integer duration;

	/**
	 * 封面图
	 */
	private String coverImg;

	/**
	 * 试播视频
	 */
	private String pilotUrl;

	/**
	 * m3u8视频地址
	 */
	private String m3u8Url;

	@ApiModelProperty("子文件数量")
	private int fileItemCount;

	public UploadResultInfo() {
		super();
	}

	public UploadResultInfo(String groupName, String fileId, Long size, String url, Boolean flag) {
		super();
		this.groupName = groupName;
		this.fileId = fileId;
		this.size = size;
		this.url = url;
		this.flag = flag;
	}

	public UploadResultInfo(String fileId, String message) {
		super();
		this.fileId = fileId;
		this.message = message;
	}

	public UploadResultInfo(String fileId, String message, Boolean flag) {
		super();
		this.fileId = fileId;
		this.message = message;
		this.flag = flag;
	}

	public UploadResultInfo(String fileId, String message, Long shardSize, Long size, Boolean flag) {
		super();
		this.fileId = fileId;
		this.message = message;
		this.shardSize = shardSize;
		this.size = size;
		this.flag = flag;
	}

	public UploadResultInfo(String fileId, String message, Long shardSize, Long size, Boolean flag, String url) {
		super();
		this.fileId = fileId;
		this.message = message;
		this.shardSize = shardSize;
		this.size = size;
		this.flag = flag;
		this.url = url;
	}

	public int getFileItemCount() {
		return fileItemCount;
	}

	public void setFileItemCount(int fileItemCount) {
		this.fileItemCount = fileItemCount;
	}

	public String getM3u8Url() {
		return m3u8Url;
	}

	public void setM3u8Url(String m3u8Url) {
		this.m3u8Url = m3u8Url;
	}

	public String getCoverImg() {
		return coverImg;
	}

	public void setCoverImg(String coverImg) {
		this.coverImg = coverImg;
	}

	public String getPilotUrl() {
		return pilotUrl;
	}

	public void setPilotUrl(String pilotUrl) {
		this.pilotUrl = pilotUrl;
	}

	public Integer getDuration() {
		return duration;
	}

	public void setDuration(Integer duration) {
		this.duration = duration;
	}

	public String getObjectKey() {
		return objectKey;
	}

	public void setObjectKey(String objectKey) {
		this.objectKey = objectKey;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public String getFileType() {
		return fileType;
	}

	public void setFileType(String fileType) {
		this.fileType = fileType;
	}

	public Integer getPage() {
		return page;
	}

	public void setPage(Integer page) {
		this.page = page;
	}

	public String getGroupName() {
		return groupName;
	}

	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}

	public String getFileId() {
		return fileId;
	}

	public void setFileId(String fileId) {
		this.fileId = fileId;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public Long getShardSize() {
		return shardSize;
	}

	public void setShardSize(Long shardSize) {
		this.shardSize = shardSize;
	}

	public Long getSize() {
		return size;
	}

	public void setSize(Long size) {
		this.size = size;
	}

	public Boolean isFlag() {
		return flag;
	}

	public void setFlag(Boolean flag) {
		this.flag = flag;
	}

	public Boolean isFinish() {
		return finish;
	}

	public void setFinish(Boolean finish) {
		this.finish = finish;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	@Override
	public String toString() {
		return "UploadResultInfo " + JSON.toJSONString(this);
	}

}