package com.pcloud.book.reading.dao;

import com.pcloud.book.reading.entity.ReadingActivity;
import com.pcloud.common.core.dao.BaseDao;

/**
 * @描述：共读活动基本设置
 * @作者：zhuyajie
 * @创建时间：17:26 2020/1/14
 * @版本：1.0
 */
public interface ReadingActivityDao extends BaseDao<ReadingActivity> {

    /**
     * 更新高级设置
     * @param readingActivity
     */
    public void updateAdditionSetting(ReadingActivity readingActivity);

    /**
     * 根据主题获取活动信息
     * @param theme
     * @return
     */
    ReadingActivity getByTheme(String theme);
    /**
     * @param theme
     * @return
     */
    Boolean themeExist(String theme);

    /**
     * 根据活动主题和入群条件获取
     * @param theme
     * @return
     */
    ReadingActivity getByThemeAndJoinCondition(String theme, Integer joinCondition);
    /**
     * 根据关键词查活动
     * @param altId
     * @param wxUserId
     * @param text
     * @return
     */
    ReadingActivity getJoinActivityByKeyword(String altId,String wxUserId,String text);
}
