package com.pcloud.book.applet.dao.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import com.pcloud.book.applet.dao.AppletThirdResourcesDao;
import com.pcloud.book.applet.dto.AppletConfigPointDTO;
import com.pcloud.book.applet.entity.AppletThirdResources;
import com.pcloud.common.core.dao.BaseDaoImpl;

@Repository("appletThirdResourcesDao")
public class AppletThirdResourcesDaoImpl extends BaseDaoImpl<AppletThirdResources> implements
        AppletThirdResourcesDao {

    @Override
    public AppletThirdResources exitThirResources(String resourcesNumber) {
        Map<String, Object> map = new HashMap<>();
        map.put("resourceNumber", resourcesNumber);
        return getSessionTemplate().selectOne(getStatement("exitThirResources"), map);
    }

    @Override
    public List<AppletThirdResources> getThirdResourcesByNewsId(Long newsId) {
        return getSessionTemplate().selectList(getStatement("getThirdResourcesByNewsId"), newsId);
    }

    @Override
    public Map<Long, AppletConfigPointDTO> getConfigPoint(List<Long> thirdResourcesIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("list", thirdResourcesIds);
        return getSessionTemplate().selectMap(getStatement("getConfigPoint"), map, "thirdResourcesId");
    }

    @Override
    public List<AppletThirdResources> getAppletsByIds(List<Long> ids) {
        Map<String, Object> map = new HashMap<>();
        map.put("ids", ids);
        return getSessionTemplate().selectList(getStatement("getAppletsByIds"), map);
    }

    @Override
    public AppletThirdResources getByResourcesId(Long id) {
        Map<String, Object> map = new HashMap<>();
        map.put("id", id);
        return getSessionTemplate().selectOne(getStatement("getByResourcesId"), map);
    }
}
