package com.pcloud.book.applet.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class BuyBookRequestDTO {

    private Long id;

    private Long bookId;

    private String bookName;

    private String coverImg;

    private Long adviserId;

    private String adviserName;

    private Long channelId;

    private Long agentId;

    private String agentName;

    private Long wechatUserId;

    private String userName;

    private String phone;

    private String address;

    private List<BuyBookRequestReplyDTO> replyList;

    @ApiModelProperty("小程序id")
    private Long miniWechatUserId;

    @ApiModelProperty("小程序openId")
    private String miniOpenId;

    @ApiModelProperty("微信昵称")
    private String nickName;

    @ApiModelProperty("是否回复")
    private Integer replyState;

    @ApiModelProperty("是否删除")
    private Integer isDelete;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    private String isbn;
}
