package com.pcloud.book.group.vo;

import java.util.List;

import javax.validation.constraints.NotNull;

import lombok.Data;

/**
 * @ClassName com.pcloud.book.group.vo.UpdateResourceColumnVO
 * @Author zhuyajie
 * @Description 资源页栏目
 * @Date 2021/3/26 17:17
 * @Version 1.0
 **/
@Data
public class UpdateResourceColumnVO {
    /**
     * 资源页id
     */
    @NotNull
    private Long resourcePageId;
    /**
     * 资源栏目id
     */
    private Long resourcePageColumnId;
    /**
     * 栏目类型
     */
    @NotNull
    private Integer columnType;
    /**
     * 栏目标题
     */
    private String columnName;
    /**
     * 栏目版式
     */
    private Integer columnFormat;
    /**
     * 栏目排序
     */
    private Integer columnSeq;
    /**
     * 客户端展示数量
     */
    private Integer showCount;
    /**
     * 客户端是否开启展示更多
     */
    private Boolean showMore;
    /**
     * 创建人
     */
    private Long createUser;

    /**
     * 图片位图片
     */
    private String logoUrl;
    /**
     * 资源列表
     */
    private List<ResourcePageItemVO> itemVOList;
    /**
     * 标签图标
     */
    private String labelIcon;
}
