package com.pcloud.book.group.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author 戴兴
 * @description TODO
 * @date 2019/7/28 15:45
 */
public class GroupStatisticVO implements Serializable {

    @ApiModelProperty("分类唯一标识")
    private Long classifyId;

    @ApiModelProperty("分类名称")
    private String classifyName;

    @ApiModelProperty("是否免费,1-免费 0-收费")
    private Integer isFree;

    @ApiModelProperty("点击人数")
    private Long clickCount;

    @ApiModelProperty("累计进群人数")
    private Long inGroupPersonCount;

    @ApiModelProperty("当前群人数")
    private Long groupPersonCount;

    @ApiModelProperty("收益")
    private BigDecimal income;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createdTime;


    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    public String getClassifyName() {
        return classifyName;
    }

    public void setClassifyName(String classifyName) {
        this.classifyName = classifyName;
    }

    public Integer getIsFree() {
        return isFree;
    }

    public void setIsFree(Integer isFree) {
        this.isFree = isFree;
    }

    public Long getClickCount() {
        return clickCount;
    }

    public void setClickCount(Long clickCount) {
        this.clickCount = clickCount;
    }

    public Long getInGroupPersonCount() {
        return inGroupPersonCount;
    }

    public void setInGroupPersonCount(Long inGroupPersonCount) {
        this.inGroupPersonCount = inGroupPersonCount;
    }

    public Long getGroupPersonCount() {
        return groupPersonCount;
    }

    public void setGroupPersonCount(Long groupPersonCount) {
        this.groupPersonCount = groupPersonCount;
    }

    public BigDecimal getIncome() {
        return income;
    }

    public void setIncome(BigDecimal income) {
        this.income = income;
    }

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    public Date getCreatedTime() {
        return createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }


    @Override
    public String toString() {
        return "GroupStatisticVO{" +
                "classifyId=" + classifyId +
                ", classifyName=" + classifyName +
                ", isFree=" + isFree +
                ", clickCount=" + clickCount +
                ", inGroupPersonCount=" + inGroupPersonCount +
                ", groupPersonCount=" + groupPersonCount +
                ", income=" + income +
                ", createdTime=" + createdTime +
                '}';
    }
}