package com.pcloud.common.core.biz;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.constant.FunnelFlowStruct.FlowNode;
import com.pcloud.common.core.constant.FunnelFlowStruct.TargetRoleType;
import com.pcloud.common.core.constant.FunnelFlowStruct.TargetType;
import com.pcloud.common.core.constant.MQQueueConstant;
import com.pcloud.common.core.dto.FunnelFlowQueueDto;
import com.pcloud.common.exceptions.BizException;

/**
 * @描述： 发送模板消息队列实现类 @作者： shuyh @创建时间： 2018年1月9日 @版本：1.0
 */
@Component("funnelFlowQueueBiz")
public class FunnelFlowQueueBizImpl implements FunnelFlowQueueBiz {

	@Autowired
	private AmqpTemplate amqpTemplate;

	/**
	 * 用户漏斗QUEUE
	 */
	@Override
	@ParamLog("用户漏斗QUEUE")
	public void sendMessageQueue(FunnelFlowQueueDto funnelFlowQueueDto) throws BizException {
		amqpTemplate.convertAndSend(MQQueueConstant.FUNNEL_FLOW, funnelFlowQueueDto);
	}

	/**
	 * 发送队列
	 */
	@Override
	public void sendMessageQueue(TargetType targetType, TargetRoleType targetRoleType, FlowNode flowNode, String ip,
			String userAgent) throws BizException {
		FunnelFlowQueueDto funnelFlowQueueDto = new FunnelFlowQueueDto(targetType, targetRoleType, flowNode, ip,
				userAgent);
		sendMessageQueue(funnelFlowQueueDto);
	}

	/**
	 * 发送队列
	 */
	@Override
	public void sendMessageQueue(TargetType targetType, Long targetId, TargetRoleType targetRoleType, Long targetRoleId,
			FlowNode flowNode) throws BizException {
		FunnelFlowQueueDto funnelFlowQueueDto = new FunnelFlowQueueDto(targetType, targetId, targetRoleType,
				targetRoleId, flowNode);
		sendMessageQueue(funnelFlowQueueDto);
	}

	/**
	 * 发送队列
	 */
	@Override
	public void sendMessageQueue(TargetType targetType, Long targetId, String subtypeCode,
			TargetRoleType targetRoleType, Long targetRoleId, FlowNode flowNode) throws BizException {
		FunnelFlowQueueDto funnelFlowQueueDto = new FunnelFlowQueueDto(targetType, targetId, subtypeCode,
				targetRoleType, targetRoleId, flowNode);
		sendMessageQueue(funnelFlowQueueDto);
	}

}
