package com.pcloud.common.core.mq;

import org.apache.activemq.command.ActiveMQQueue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.core.JmsTemplate;

/**
 * @描述：
 * 
 * @作者：songx
 * @创建时间：2017年9月14日,上午11:40:25 @版本：1.0
 */
@Configuration
public class ActiveMqProducer {

	@Autowired
	private CachingConnectionFactory cachingConnectionFactory;

	@Autowired(required = false)
	@Qualifier("convertQueue")
	private ActiveMQQueue convertQueue;

	@Autowired(required = false)
	@Qualifier("labelUsedQueue")
	private ActiveMQQueue labelUsedQueue;

	@Autowired(required = false)
	@Qualifier("logQueue")
	private ActiveMQQueue logQueue;

	@Autowired(required = false)
	@Qualifier("messageQueue")
	private ActiveMQQueue messageQueue;

	@Autowired(required = false)
	@Qualifier("weektaskQueue")
	private ActiveMQQueue weektaskQueue;

	@Autowired(required = false)
	@Qualifier("templateQueue")
	private ActiveMQQueue templateQueue;

	@Autowired(required = false)
	@Qualifier("userActionQueue")
	private ActiveMQQueue userActionQueue;

	@Autowired(required = false)
	@Qualifier("funnelFlowQueue")
	private ActiveMQQueue funnelFlowQueue;

	@Autowired(required = false)
	@Qualifier("fundQueue")
	private ActiveMQQueue fundQueue;

	@Autowired(required = false)
	@Qualifier("dynamicQueue")
	private ActiveMQQueue dynamicQueue;

	@Autowired(required = false)
	@Qualifier("exapiQueue")
	private ActiveMQQueue exapiQueue;

	@Autowired(required = false)
	@Qualifier("frontEventQueue")
	private ActiveMQQueue frontEventQueue;

	@Autowired(required = false)
	@Qualifier("transcodeQueue")
	private ActiveMQQueue transcodeQueue;

	@Autowired(required = false)
	@Qualifier("promotionTaskQueue")
	private ActiveMQQueue promotionTaskQueue;

	@Autowired(required = false)
	@Qualifier("promotionTerminateQueue")
	private ActiveMQQueue promotionTerminateQueue;

	/**
	 * 获取音视频转码JMS
	 *
	 * @return
	 */
	@Bean(name = "jmsConvertTemplate")
	public JmsTemplate getConvertTemplate() {
		JmsTemplate jmsTemplate = getJmsTemplate();
		jmsTemplate.setDefaultDestination(convertQueue);
		return jmsTemplate;
	}

	/**
	 * 获取标签使用JMS
	 *
	 * @return
	 */
	@Bean(name = "jmsLabelUsedTemplate")
	public JmsTemplate getLabelUsedTemplate() {
		JmsTemplate jmsTemplate = getJmsTemplate();
		jmsTemplate.setDefaultDestination(labelUsedQueue);
		return jmsTemplate;
	}

	/**
	 * 获取日志JMS
	 *
	 * @return
	 */
	@Bean(name = "jmsLogTemplate")
	public JmsTemplate getLogTemplate() {
		JmsTemplate jmsTemplate = getJmsTemplate();
		jmsTemplate.setDefaultDestination(logQueue);
		return jmsTemplate;
	}

	/**
	 * 获取消息JMS
	 *
	 * @return
	 */
	@Bean(name = "jmsMessageTemplate")
	public JmsTemplate getMessageTemplate() {
		JmsTemplate jmsTemplate = getJmsTemplate();
		jmsTemplate.setDefaultDestination(messageQueue);
		return jmsTemplate;
	}

	/**
	 * 获取编辑任务JMS
	 *
	 * @return
	 */
	@Bean(name = "jmsWeektaskTemplate")
	public JmsTemplate getWeektaskTemplate() {
		JmsTemplate jmsTemplate = getJmsTemplate();
		jmsTemplate.setDefaultDestination(weektaskQueue);
		return jmsTemplate;
	}

	/**
	 * 获取模板消息JMS
	 *
	 * @return
	 */
	@Bean(name = "jmsTemplateTemplate")
	public JmsTemplate getTemplateTemplate() {
		JmsTemplate jmsTemplate = getJmsTemplate();
		jmsTemplate.setDefaultDestination(templateQueue);
		return jmsTemplate;
	}

	/**
	 * 获取用户行为JMS
	 *
	 * @return
	 */
	@Bean(name = "jmsUserActionTemplate")
	public JmsTemplate getUserActionTemplate() {
		JmsTemplate jmsTemplate = getJmsTemplate();
		jmsTemplate.setDefaultDestination(userActionQueue);
		return jmsTemplate;
	}

	/**
	 * 获取漏斗流程JMS
	 *
	 * @return
	 */
	@Bean(name = "jmsFunnelFlowTemplate")
	public JmsTemplate getFunnelFlowTemplate() {
		JmsTemplate jmsTemplate = getJmsTemplate();
		jmsTemplate.setDefaultDestination(funnelFlowQueue);
		return jmsTemplate;
	}

	/**
	 * 基金修改监控JMS
	 *
	 * @return
	 */
	@Bean(name = "jmsFundTemplate")
	public JmsTemplate getJmsFundTemplate() {
		JmsTemplate jmsTemplate = getJmsTemplate();
		jmsTemplate.setDefaultDestination(fundQueue);
		return jmsTemplate;
	}

	/**
	 * 作者动态监控JMS
	 *
	 * @return
	 */
	@Bean(name = "jmsDynamicTemplate")
	public JmsTemplate getJmsDynamicTemplate() {
		JmsTemplate jmsTemplate = getJmsTemplate();
		jmsTemplate.setDefaultDestination(dynamicQueue);
		return jmsTemplate;
	}

	/**
	 * 收集事件
	 *
	 * @return
	 */
	@Bean(name = "jmsFrontEventTemplate")
	public JmsTemplate getJmsFrontEventTemplate() {
		JmsTemplate jmsTemplate = getJmsTemplate();
		jmsTemplate.setDefaultDestination(frontEventQueue);
		return jmsTemplate;
	}

	/**
	 * 对外api监控JMS
	 *
	 * @author wangrui
	 * @date 10:40 2018/4/13
	 */
	@Bean(name = "jmsExapiTemplate")
	public JmsTemplate getJmsExapiTemplate() {
		JmsTemplate jmsTemplate = getJmsTemplate();
		jmsTemplate.setDefaultDestination(exapiQueue);
		return jmsTemplate;
	}

	/**
	 * 文件转码JMS
	 *
	 * @return
	 */
	@Bean(name = "jmsTranscodeTemplate")
	public JmsTemplate getJmsTranscodeTemplate() {
		JmsTemplate jmsTemplate = getJmsTemplate();
		jmsTemplate.setDefaultDestination(transcodeQueue);
		return jmsTemplate;
	}

	/**
	 * 获取促销任务JMS
	 *
	 * @return
	 */
	@Bean(name = "jmsPromotionTaskTemplate")
	public JmsTemplate getJmsPromotionTaskTemplate() {
		JmsTemplate jmsTemplate = getJmsTemplate();
		jmsTemplate.setDefaultDestination(promotionTaskQueue);
		return jmsTemplate;
	}

	/**
	 * 获取促销终止JMS
	 *
	 * @return
	 */
	@Bean(name = "jmsPromotionTerminateTemplate")
	public JmsTemplate getJmsPromotionTerminateTemplate() {
		JmsTemplate jmsTemplate = getJmsTemplate();
		jmsTemplate.setDefaultDestination(promotionTerminateQueue);
		return jmsTemplate;
	}

	/**
	 * 获取JMS模板
	 *
	 * @return
	 */
	private JmsTemplate getJmsTemplate() {
		JmsTemplate jmsTemplate = new JmsTemplate(cachingConnectionFactory);
		jmsTemplate.setReceiveTimeout(10000);
		return jmsTemplate;
	}

}
