package com.pcloud.common.utils;/**
 * Created by ${user} on ${date}
 */

import com.pcloud.common.entity.UploadResultInfo;
import com.pcloud.common.enums.ImageTypeEnum;
import com.pcloud.common.utils.aliyun.OssUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

/**
 * @author TianChao
 * @date 2018/10/13 15:02
 */
public class PictureUtil {

    private static final Logger LOGGER = LoggerFactory.getLogger(PictureUtil.class);

    private static Color defaultColor = new Color(252, 252, 252);
    private static Color borderColor = new Color(221, 221, 221);

    private static String playPic = "https://file.5rs.me/oss/uploadfe/png/3c687bffac4d885ecfff8517d6c3f9c2.png";
    private static String defaultBackgroundPic = "https://oss.5rs.me/oss/uploadfe/png/3003b8978e85052f96ababdf7d46f70a.png";
    private static String borderPic = "C:\\Users\\LiHao\\Desktop\\封面图\\书本背景.png";

    public static Color getImagePixel(String imgFile)  {
        BufferedImage bi = null;
        try {
            if(imgFile.contains("http")){
                bi = ImageIO.read(new URL(imgFile));
            }else{
                bi = ImageIO.read(new File(imgFile));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        int width = bi.getWidth();
        int height = bi.getHeight();
        int sum=width*height;
        int minx = bi.getMinX();
        int miny = bi.getMinY();
        int R = 0;
        int G = 0;
        int B = 0;
        for (int i = minx; i < width; i++) {
            for (int j = miny; j < height; j++) {
                int pixel = bi.getRGB(i, j);
                R +=(pixel & 0xff0000) >> 16;
                G +=(pixel & 0xff00) >> 8;
                B +=(pixel & 0xff);
            }
        }
        R = R/sum;
        G = G/sum;
        B = B/sum;
        return new Color(R,G,B);
    }

    public static String toBrowserHexValue(int number) {
        StringBuilder builder = new StringBuilder(
                Integer.toHexString(number & 0xff));
        while (builder.length() < 2) {
            builder.append("0");
        }
        return builder.toString().toUpperCase();
    }



    public static String getQrCover(String bookPic,boolean isDefault){
        String resultPath = "";
        try {
            int backWidth = 702;
            int backHeight = 299;
            int splitPoint = 196;
            int bookWidth = 157;
            int bookHeight = 224;
            int borderWidth = 185;
            int borderHeight = 252;
            int playButtonSize = 80;
            //取书封面和播放按钮图
            BufferedImage bookPicImage;
            BufferedImage playPicImage;
            BufferedImage defaultBackgroundImage;
            bookPicImage = ImageIO.read(new URL(bookPic));

            if(bookPicImage.getWidth()*bookPicImage.getHeight()>10000) {
                BufferedImage pic1 = new BufferedImage(bookWidth, bookHeight, BufferedImage.TYPE_3BYTE_BGR);
                Graphics2D g11 = pic1.createGraphics();
                g11.drawImage(bookPicImage.getScaledInstance(bookWidth, bookHeight, Image.SCALE_SMOOTH), 0, 0, null);
                g11.dispose();
                bookPicImage = pic1;
            }

            playPicImage = ImageIO.read(new URL(playPic));
            defaultBackgroundImage = ImageIO.read(new URL(defaultBackgroundPic));
            //画一个空的背景
            BufferedImage bg = new BufferedImage(backWidth, backHeight, BufferedImage.TYPE_3BYTE_BGR);
            Graphics2D g = bg.createGraphics();
            //获取主题色
            Color c = getImagePixel(bookPic);
            //画纯色的背景或者默认背景图
            g.setColor(c);
            if(isDefault){
                g.drawImage(defaultBackgroundImage.getScaledInstance(backWidth,splitPoint, Image.SCALE_DEFAULT), 0, 0, null);
            }else {
                g.fillRect(0, 0, backWidth, splitPoint);
            }
            g.setColor(defaultColor);
            g.fillRect(0, splitPoint, backWidth, backHeight-splitPoint);
            //插入书籍图和播放按钮
            g.drawImage(bookPicImage.getScaledInstance(bookWidth,bookHeight, Image.SCALE_SMOOTH), (backWidth-bookWidth)/2, (backHeight-bookHeight)/2, null);
            g.drawImage(playPicImage.getScaledInstance(playButtonSize,playButtonSize, Image.SCALE_DEFAULT), (backWidth-playButtonSize)/2, (backHeight-playButtonSize)/2, null);
            //画边框
            g.setColor(borderColor);
            g.drawRect((backWidth-bookWidth)/2, (backHeight-bookHeight)/2,bookWidth,bookHeight);
            // 保存并上传图片
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write(bg, ImageTypeEnum.JPG.value, os);
            UploadResultInfo uploadResultInfo = OssUtils.uploadFileByte(os.toByteArray(), UUIDUitl.taskName(), ImageTypeEnum.JPG.value);
            os.close();
            resultPath = uploadResultInfo == null ? null : uploadResultInfo.getUrl();
        } catch (Exception e) {
            LOGGER.error("生成合成图失败,url="+bookPic+"====="+e.getMessage(),e);
        }
        return resultPath;

    }


    public static void main(String[] args) {
   //     String bookPic = "https://file.5rs.me/oss/upload/image/jpg/c2c7f0b85f9f4eb683cd86a2945bc5e5.jpg";
        String s = "";
        String bookPic = "C:\\Users\\LiHao\\Desktop\\封面图\\aa.jpg";
        String playPic = "C:\\Users\\LiHao\\Desktop\\封面图\\播放按钮.png";
        String defaultBackgroundPic = "C:\\Users\\LiHao\\Desktop\\封面图\\默认图背景.png";
        String resultPath = "C:\\Users\\LiHao\\Desktop\\封面图\\result.jpg";

        String oath = "C:\\Users\\LiHao\\Desktop\\封面图\\书本背景.png";

        Boolean isDefalut = false;
        try {
            //取书封面和播放按钮图
            BufferedImage bookPicImage;
            BufferedImage playPicImage;
            BufferedImage defaultBackgroudImage;
            BufferedImage oathI;
            if(bookPic.contains("https:")){
                 bookPicImage = ImageIO.read(new URL(bookPic));
                 playPicImage = ImageIO.read(new URL(playPic));
                 defaultBackgroudImage = ImageIO.read(new URL(defaultBackgroundPic));
                oathI = ImageIO.read(new URL(oath));
            }else{
                bookPicImage = ImageIO.read(new File(bookPic));
                playPicImage = ImageIO.read(new File(playPic));
                defaultBackgroudImage = ImageIO.read(new File(defaultBackgroundPic));
                oathI = ImageIO.read(new File(oath));
            }

            //画一个空的背景
            BufferedImage bg = new BufferedImage(702, 299, BufferedImage.TYPE_3BYTE_BGR);
            Graphics2D g = bg.createGraphics();
            //获取主题色
            Color c = getImagePixel(bookPic);


            //画纯色的背景或者默认背景图
            g.setColor(c);
            if(isDefalut){
                g.drawImage(defaultBackgroudImage.getScaledInstance(702,196, Image.SCALE_DEFAULT), 0, 0, null);
            }else {
                g.fillRect(0, 0, 702, 196);
            }
            g.setColor(new Color(252, 252, 252));
            g.fillRect(0, 196, 702, 102);

            g.setColor(new Color(221, 221, 221));
            //插入书籍图和播放按钮


          //  g.drawImage(oathI.getScaledInstance(185,252, Image.SCALE_DEFAULT), 258, 33, null);



            BufferedImage image = new BufferedImage(157, 200, BufferedImage.TYPE_INT_ARGB);
            Graphics2D gs = image.createGraphics();

            Map mapH = new HashMap();
            mapH.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON); //抗锯齿 （抗锯齿总开关）
            mapH.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            gs.setRenderingHints(mapH);

         //   gs.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            gs.setClip(new RoundRectangle2D.Double(0, 0, 157, 224, 12, 12));
            gs.drawImage(bookPicImage.getScaledInstance(157,224, Image.SCALE_DEFAULT), 0, 0, null);

            g.drawImage(image.getScaledInstance(157,224, Image.SCALE_DEFAULT), 272, 38, null);



            g.drawImage(playPicImage.getScaledInstance(80,80, Image.SCALE_DEFAULT), 306, 105, null);
      //      g.drawRect(265,30,172,238);


            //保存图片
            if(bookPic.contains("https:")) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ImageIO.write(bg, ImageTypeEnum.JPG.value, os);
                UploadResultInfo uploadResultInfo = OssUtils.uploadFileByte(os.toByteArray(), UUIDUitl.taskName(), ImageTypeEnum.JPG.value);
                os.close();
                s = uploadResultInfo == null ? null : uploadResultInfo.getUrl();
            }else{
                OutputStream os = new FileOutputStream(resultPath);
                ImageIO.write(bg, ImageTypeEnum.JPG.value, os);
                os.close();
            }
            System.out.println(s);
        } catch (Exception e) {
            System.out.println(e.getMessage());
        }

    }





}
