package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.AdvertisingMasterDao;
import com.pcloud.book.advertising.dto.AdvertisingMasterDTO;
import com.pcloud.book.advertising.dto.OldBrandMasterDTO;
import com.pcloud.book.advertising.entity.AdvertisingMaster;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * Description 广告主数据访问层接口实现类
 * Created by PENG on 2019/4/26.
 */
@Repository("advertisingMasterDao")
public class AdvertisingMasterDaoImpl extends BaseDaoImpl<AdvertisingMaster> implements AdvertisingMasterDao {

    /**
     * 获取所有广告主
     */
    @Override
    public List<AdvertisingMasterDTO> getAllMaster() {
        return super.getSqlSession().selectList(getStatement("getAllMaster"));
    }

    /**
     * 获取广告主DTO
     */
    @Override
    public AdvertisingMasterDTO getDTOById(Long masterId) {
        return super.getSqlSession().selectOne(getStatement("getDTOById"), masterId);
    }

    @Override
    public List<OldBrandMasterDTO> getMasterBrand() {
        return getSessionTemplate().selectList(getStatement("getMasterBrand"));
    }

    @Override
    public void updateLoginId(String masterName) {
        getSessionTemplate().update(getStatement("updateLoginId"), masterName);
    }

}
