package com.pcloud.book.group.constant;

import com.pcloud.book.group.dto.AutoUpdateGroupNumDTO;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * book业务常量类
 */
public class BookBusinessConstants {

    /**
     * 需更新微信群信息
     */
    public static final Map<String, AutoUpdateGroupNumDTO> GROUP_NUM_DTO_MAP = new ConcurrentHashMap<>(128);

    /**
     * 小号上次心跳时间缓存
     */
    public static final String ACTIVE_ROBOT_CACHE_KEY_PREFIX = "activerobot:";

    /**
     * 发邮件间隔时长
     */
    public static final String EMAIL_SPAN_TIME = "emailSpanTime:";

    /**
     * 收款状态
     */
    public enum CollectionStatus {
        /**
         * 代收款
         */
        COLLECTION(1),
        /**
         * 收款中
         */
        RECEIVING(2),
        /**
         * 收款成功
         */
        COLLECTION_SUCCESSFUL(3);

        private Integer code;

        CollectionStatus(Integer code) {
            this.code = code;
        }

        public Integer getCode() {
            return code;
        }
    }

}
