package com.pcloud.book.pcloudkeyword.dao.impl;

import com.pcloud.book.pcloudkeyword.dao.PcloudRobotWelcomeDao;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobotWelcome;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("pcloudRobotWelcomeDao")
public class PcloudRobotWelcomeDaoImpl extends BaseDaoImpl<PcloudRobotWelcome> implements PcloudRobotWelcomeDao {

    @Override
    public List<PcloudRobotWelcome> getRobotWelcomeListByPcloudRobotId(Long pcloudRobotId) {
        return super.getSqlSession().selectList(getStatement("getRobotWelcomeListByPcloudRobotId"), pcloudRobotId);
    }

    @Override
    public void deleteByPcloudRobotId(Long pcloudRobotId) {
        super.getSqlSession().delete(getStatement("deleteByPcloudRobotId"), pcloudRobotId);
    }

    @Override
    public void batchInsert(List<PcloudRobotWelcome> robotWelcomeList) {
        super.getSqlSession().insert(getStatement("batchInsert"), robotWelcomeList);
    }

    @Override
    public List<PcloudRobotWelcome> getRobotWelcomeListByPcloudClassifyId(Long pcloudClassifyId,Integer robotType) {
        Map<String,Object> map=new HashMap<>();
        map.put("pcloudClassifyId",pcloudClassifyId);
        map.put("robotType",robotType);
        return super.getSqlSession().selectList(getStatement("getRobotWelcomeListByPcloudClassifyId"), map);
    }

    @Override
    public void deleteByPcloudClassifyId(Long pcloudClassifyId,Integer robotType) {
        Map<String,Object> map=new HashMap<>();
        map.put("pcloudClassifyId",pcloudClassifyId);
        map.put("robotType",robotType);
        super.getSqlSession().delete(getStatement("deleteByPcloudClassifyId"), map);
    }

}
