package com.pcloud.book.rightsSetting.dao.check;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.rightsSetting.entity.RightsSetting;
import com.pcloud.common.utils.string.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Component("权益设置参数校验")
@Slf4j
public class RightsSettingCheck {

    public void rightsSettingCheck(RightsSetting rightsSetting) {
        log.info("新增权益设置参数校验");
        if (null == rightsSetting){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"参数为空！");
        }
        if (StringUtil.isEmpty(rightsSetting.getIntroduce())){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"权益介绍为空！");
        }
        if (StringUtil.isEmpty(rightsSetting.getDetail())){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"权益详情为空！");
        }
        if (null == rightsSetting.getCount()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"权益个数为空！");
        }
        if (null == rightsSetting.getFirstClassify()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"分类为空！");
        }
    }
}
