/**
 *
 */
package com.pcloud.book.book.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;

import java.util.Date;

/**
 * @描述：书籍关联应用实体
 * @作者：songx
 * @创建时间：2016年12月23日,下午3:45:37
 * @版本：1.0
 */
public class BookAppDto extends BaseDto {

    /**
     *
     */
    private static final long serialVersionUID = -7357947235454060827L;

    /**
     * 书籍应用标识
     */
    private Long bookAppId;

    /**
     * 书籍标识
     */
    private Long bookId;

    /**
     * 应用标识
     */
    private Long appId;

    /**
     * 渠道标识
     */
    private Long channelId;

    /**
     * 应用类型名称
     */
    private String typeName;

    /**
     * 应用标题
     */
    private String title;


    /**
     * 方图
     */
    private String squareImg;

    /**
     * 横图
     */
    private String transverseImg;

    /**
     * 应用类型编码
     */
    private String typeCode;

    /**
     * 简介
     */
    private String remark;

    /**
     * 是否过期
     */
    private Boolean overdue;

    /**
     * 应用创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date appCreatedDate;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getAppCreatedDate() {
        return appCreatedDate;
    }

    public void setAppCreatedDate(Date appCreatedDate) {
        this.appCreatedDate = appCreatedDate;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getBookAppId() {
        return bookAppId;
    }

    public void setBookAppId(Long bookAppId) {
        this.bookAppId = bookAppId;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSquareImg() {
        return squareImg;
    }

    public void setSquareImg(String squareImg) {
        this.squareImg = squareImg;
    }

    public String getTransverseImg() {
        return transverseImg;
    }

    public void setTransverseImg(String transverseImg) {
        this.transverseImg = transverseImg;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Boolean getOverdue() {
        return overdue;
    }

    public void setOverdue(Boolean overdue) {
        this.overdue = overdue;
    }

    @Override
    public String toString() {
        return "BookAppDto [bookAppId=" + bookAppId + ", bookId=" + bookId + ", appId=" + appId + ", channelId="
                + channelId + ", typeName=" + typeName + ", title=" + title + ", squareImg=" + squareImg
                + ", transverseImg=" + transverseImg + ", typeCode=" + typeCode + ", remark=" + remark + ", overdue="
                + overdue + "]";
    }

}
