package com.pcloud.book.adnews.check;

import com.pcloud.book.adnews.entity.AdNewsGroup;
import com.pcloud.book.adnews.entity.AdNewsSet;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.string.StringUtil;
import org.springframework.stereotype.Component;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/7/17 17:18
 **/
@Component("adNewsCheck")
public class AdNewsCheck {


    public void createAdNewsSetCheck(AdNewsSet adNewsSet){
        if (adNewsSet==null){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"参数错误");
        }
        if (ListUtils.isEmpty(adNewsSet.getAdNewsGroups())){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"发送群分类不能为空！");
        }
        if (adNewsSet.getSendCount()==null||adNewsSet.getSendCount()<=0){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"推送条数不能为空且必须大于0！");
        }
        if (adNewsSet.getHasMorningOpen()==null){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"是否开启早报不能为空！");
        }
        if (adNewsSet.getHasEveningOpen()==null){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"是否开启晚报不能为空！");
        }
        if (adNewsSet.getHasStartContent()==null){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"是否开启开场语不能为空！");
        }
        if (adNewsSet.getHasEndContent()==null){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"是否开启结束语不能为空！");
        }
        if (adNewsSet.getHasMorningOpen()&&StringUtil.isEmpty(adNewsSet.getMorningTime())){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"早报时间不能为空！");
        }
        if (adNewsSet.getHasEveningOpen()&&StringUtil.isEmpty(adNewsSet.getEveningTime())){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"晚报时间不能为空！");
        }
        if (adNewsSet.getHasStartContent()&&StringUtil.isEmpty(adNewsSet.getStartContent())){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"开场语不能为空！");
        }
        if (adNewsSet.getHasEndContent()&&StringUtil.isEmpty(adNewsSet.getEndContent())){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"结束语不能为空！");
        }
        for(AdNewsGroup adNewsGroup:adNewsSet.getAdNewsGroups()){
            if (adNewsGroup==null){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR,"早晚报关联不能为空！");
            }
            if (adNewsGroup.getClassifyId()==null){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR,"群分类id不能为空！");
            }
            if (adNewsGroup.getBookGroupId()==null){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR,"社群码id不能为空！");
            }
        }

    }

}
