package com.pcloud.book.adnews.dao.impl;

import com.pcloud.book.adnews.dao.AdNewsGroupDao;
import com.pcloud.book.adnews.entity.AdNewsGroup;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/7/17 16:18
 **/
@Repository("adNewsGroupDao")
public class AdNewsGroupDaoImpl extends BaseDaoImpl<AdNewsGroup> implements AdNewsGroupDao {
    @Override
    public Integer batchInsert(List<AdNewsGroup> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"), list);
    }

    @Override
    public void deleteByAdNewsSetId(Long adNewsSetId) {
        super.getSqlSession().update(getStatement("deleteByAdNewsSetId"), adNewsSetId);
    }

    @Override
    public List<AdNewsGroup> getListByAdNewsSetId(Long adNewsSetId) {
        return super.getSqlSession().selectList(getStatement("getListByAdNewsSetId"), adNewsSetId);
    }
}
