package com.pcloud.book.adnews.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/7/17 15:03
 **/
@ApiModel("新闻")
public class AdNews extends BaseEntity {

    private static final long serialVersionUID = -8389321600700338319L;

    @ApiModelProperty("类型")
    private String type;

    @ApiModelProperty("来源")
    private String newsFrom;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("发布者")
    private String publisher;

    @ApiModelProperty("链接")
    private String url;

    @ApiModelProperty("短链接")
    private String shortUrl;

    @ApiModelProperty("发布日期")
    private String newsDate;

    @ApiModelProperty("是否使用")
    private Boolean hasUsed;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getNewsFrom() {
        return newsFrom;
    }

    public void setNewsFrom(String newsFrom) {
        this.newsFrom = newsFrom;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPublisher() {
        return publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getShortUrl() {
        return shortUrl;
    }

    public void setShortUrl(String shortUrl) {
        this.shortUrl = shortUrl;
    }

    public String getNewsDate() {
        return newsDate;
    }

    public void setNewsDate(String newsDate) {
        this.newsDate = newsDate;
    }

    public Boolean getHasUsed() {
        return hasUsed;
    }

    public void setHasUsed(Boolean hasUsed) {
        this.hasUsed = hasUsed;
    }

    @Override
    public String toString() {
        return "AdNews{" +
                "type='" + type + '\'' +
                ", newsFrom='" + newsFrom + '\'' +
                ", title='" + title + '\'' +
                ", publisher='" + publisher + '\'' +
                ", url='" + url + '\'' +
                ", shortUrl='" + shortUrl + '\'' +
                ", newsDate='" + newsDate + '\'' +
                ", hasUsed=" + hasUsed +
                "} " + super.toString();
    }
}
