package com.pcloud.book.advertising.dao;

import java.util.List;
import com.pcloud.book.advertising.dto.AdvertisingMasterDTO;
import com.pcloud.book.advertising.entity.AdvertisingMaster;
import com.pcloud.common.core.dao.BaseDao;

/**
 * Description 广告主数据访问层接口
 * Created by PENG on 2019/4/26.
 */
public interface AdvertisingMasterDao extends BaseDao<AdvertisingMaster> {

    /**
     * 获取所有广告主
     * @return
     */
    List<AdvertisingMasterDTO> getAllMaster();

    /**
     * 获取广告主DTO
     * @param masterId 广告主ID
     * @return
     */
    AdvertisingMasterDTO getDTOById(Long masterId);
}
