package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.AdvertisingPlanGroupDao;
import com.pcloud.book.advertising.entity.AdvertisingPlanGroup;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/6/27 15:37
 **/
@Repository("advertisingPlanGroupDao")
public class AdvertisingPlanGroupDaoImpl extends BaseDaoImpl<AdvertisingPlanGroup> implements AdvertisingPlanGroupDao {
    @Override
    public Integer batchInsert(List<AdvertisingPlanGroup> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"), list);
    }

    @Override
    public List<AdvertisingPlanGroup> getListByPlanId(Long planId) {
        return super.getSqlSession().selectList(getStatement("getListByPlanId"), planId);
    }

    @Override
    public void deleteByIds(List<Long> ids, Long partyId) {
        Map<String, Object> map = new HashMap<>();
        map.put("ids", ids);
        map.put("partyId", partyId);
        super.getSqlSession().delete(getStatement("deleteByIds"), map);
    }

    @Override
    public void deleteByPlanId(Long planId, Long partyId) {
        Map<String, Object> map = new HashMap<>();
        map.put("planId", planId);
        map.put("partyId", partyId);
        super.getSqlSession().delete(getStatement("deleteByPlanId"), map);
    }

    @Override
    public List<AdvertisingPlanGroup> getListByPlanIds(List<Long> planIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("planIds", planIds);
        return super.getSqlSession().selectList(getStatement("getListByPlanIds"), map);
    }
}
