package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.BmOptionItemDao;
import com.pcloud.book.advertising.entity.AdvertisingBmOptionItem;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

/**
 * @描述：报名选项清单
 * @作者：zhuyajie
 * @创建时间：20:16 2019/6/27
 * @版本：1.0
 */
@Component("bmOptionItemDao")
public class BmOptionItemDaoImpl extends BaseDaoImpl<AdvertisingBmOptionItem> implements BmOptionItemDao{

    /**
     * 根据选项ID删除选项清单
     */
    @Override
    public long deleteByOptionId(Long optionId) {
        return super.getSqlSession().delete(getStatement("deleteByOptionId"), optionId);
    }

    @Override
    public String getValueById(Long optionItemId) {
        return getSessionTemplate().selectOne(getStatement("getValueById"),optionItemId);
    }
}
