package com.pcloud.book.advertising.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;
import java.util.List;

/**
 * 报表选项
 */
public class AdvertisingBmOption extends BaseEntity{

    /**
     *广告id
     */
    private Long adId;
    /**
     *排序值
     */
    private Long seq;
    /**
     *选项名称
     */
    private String itemTitle;
    /**
     *选项描述
     */
    private String itemDesc;
    /**
     *选项类型
     */
    private String itemInputType;
    /**
     *选项数据类型
     */
    private String itemDataType;
    /**
     *是否必填
     */
    private Boolean required;

    private Long createUser;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;

    private Long updateUser;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date updateTime;

    /**
     * 选项列表
     */
    private List<AdvertisingBmOptionItem> optionItem;

    public Long getAdId() {
        return adId;
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    public Long getSeq() {
        return seq;
    }

    public void setSeq(Long seq) {
        this.seq = seq;
    }

    public String getItemTitle() {
        return itemTitle;
    }

    public void setItemTitle(String itemTitle) {
        this.itemTitle = itemTitle == null ? null : itemTitle.trim();
    }

    public String getItemDesc() {
        return itemDesc;
    }

    public void setItemDesc(String itemDesc) {
        this.itemDesc = itemDesc == null ? null : itemDesc.trim();
    }

    public String getItemInputType() {
        return itemInputType;
    }

    public void setItemInputType(String itemInputType) {
        this.itemInputType = itemInputType == null ? null : itemInputType.trim();
    }

    public String getItemDataType() {
        return itemDataType;
    }

    public void setItemDataType(String itemDataType) {
        this.itemDataType = itemDataType == null ? null : itemDataType.trim();
    }

    public Boolean getRequired() {
        return required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(Long updateUser) {
        this.updateUser = updateUser;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public List<AdvertisingBmOptionItem> getOptionItem() {
        return optionItem;
    }

    public void setOptionItem(List<AdvertisingBmOptionItem> optionItem) {
        this.optionItem = optionItem;
    }

    @Override
    public String toString() {
        return "AdvertisingBmOption{" +
                "adId=" + adId +
                ", seq=" + seq +
                ", itemTitle='" + itemTitle + '\'' +
                ", itemDesc='" + itemDesc + '\'' +
                ", itemInputType='" + itemInputType + '\'' +
                ", itemDataType='" + itemDataType + '\'' +
                ", required=" + required +
                ", createUser=" + createUser +
                ", createTime=" + createTime +
                ", updateUser=" + updateUser +
                ", updateTime=" + updateTime +
                ", optionItem=" + optionItem +
                '}';
    }
}