/**
 * 
 */
package com.pcloud.book.book.biz;

import java.util.List;
import java.util.Map;

import com.pcloud.book.book.dto.BookProductDto;
import com.pcloud.book.book.entity.BookProduct;
import com.pcloud.common.exceptions.BizException;

/**
 * @描述：
 * 
 * @作者：songx
 * @创建时间：2016年12月23日,下午3:58:54 @版本：1.0
 */
public interface BookProductBiz {

	/**
	 * 添加书籍作品关联关系
	 * 
	 * @param bookProduct
	 *            书籍作品关联信息
	 * @throws BizException
	 */
	public void create(BookProduct bookProduct) throws BizException;

	/**
	 * 删除作品应用关联关系
	 * 
	 * @param bookId
	 *            图书标识
	 * @param productId
	 *            作品标识
	 * @param adviserId
	 *            编辑标识
	 * @param channelId
	 *            渠道标识
	 * @return
	 */
	public void delete(Long bookId, Long productId, Long adviserId, Long channelId) throws BizException;

	/**
	 * 书籍删除作品应用关联关系
	 * 
	 * @param bookId
	 *            图书标识
	 * @throws BizException
	 */
	public void deleteByBook(Long bookId) throws BizException;

	/**
	 * 批量删除作品关联关系
	 * 
	 * @param bookIds
	 *            图书标识列表
	 * @throws BizException
	 */
	public void deleteByBooks(List<Long> bookIds) throws BizException;

	/**
	 * 获取书籍关联的作品
	 * 
	 * @param bookId
	 *            图书标识
	 * @param adviserId
	 *            编辑标识
	 * @param channelId
	 *            渠道标识
	 * @return
	 */
	public List<BookProductDto> getListById(Long bookId, Long adviserId, Long channelId) throws BizException;

	/**
	 * 获取书籍关联的作品(包含作品基础信息)
	 * 
	 * @param bookId
	 *            图书标识
	 * @param adviserId
	 *            编辑标识
	 * @param channelId
	 *            渠道标识
	 * @return
	 * @throws BizException
	 */
	public List<Object> getProListById(Long bookId, Long adviserId, Long channelId) throws BizException;

	/**
	 * 获取书籍关联的问答(包含问答基础信息)
	 * 
	 * @param bookId
	 *            图书标识
	 * @param adviserId
	 *            编辑标识
	 * @param channelId
	 *            渠道标识
	 * @return
	 * @throws BizException
	 */
	public List<Object> getQaListById(Long bookId, Long adviserId, Long channelId) throws BizException;

	/**
	 * 根据书籍和渠道删除书籍作品关联信息
	 * 
	 * @param bookId
	 *            图书标识
	 * @param channelId
	 *            渠道标识
	 * @return
	 */
	public void deleteByBookAndChannel(Long bookId, Long channelId) throws BizException;

	/**
	 * 设置录音
	 * 
	 * @param bookProduct
	 *            图书作品关联信息
	 * @param adviserId
	 *            编辑标识
	 */
	public void setSound(BookProduct bookProduct, Long adviserId);

	/**
	 * 获取书籍关联作品
	 * 
	 * @param bookId
	 *            图书标识
	 * @param adviserId
	 *            编辑标识
	 * @param channelId
	 *            渠道标识
	 * @return
	 */
	public Map<Long, BookProductDto> getMapById(Long bookId, Long adviserId, Long channelId);

	/**
	 * 清除录音
	 * 
	 * @param videoId
	 *            录音标识
	 */
	public void clearSound(Long videoId);

	/**
	 * 更新商品类型
	 */
	public void updateProductType();

	/**
	 * 获取书籍关联作品
	 * 
	 * @param bookId
	 *            图书标识
	 * @param channelId
	 *            运用标识
	 * @param adviserId
	 *            编辑标识
	 * @return
	 */
	public List<BookProductDto> list4Adviser(Long bookId, Long channelId, Long adviserId);

	/**
	 * 获取图书关联超级作者商品个数
	 * 
	 * @param adviserId
	 *            编辑标识
	 * @param bookId
	 *            图书标识
	 * @param channelId
	 *            渠道标识
	 * @return
	 */
	public Integer getSuperProCount(Long adviserId, Long bookId, Long channelId);

	/**
	 * 获取图书关联商品个数
	 * 
	 * @param adviserId
	 *            编辑标识
	 * @param bookId
	 *            图书标识
	 * @param channelId
	 *            渠道标识
	 * @return
	 */
	public Integer getProCount(Long adviserId, Long bookId, Long channelId);
}
