package com.pcloud.book.book.service.impl;

import com.google.common.collect.Lists;

import com.pcloud.book.book.service.KeywordService;
import com.pcloud.book.group.biz.BookGroupClassifyBiz;
import com.pcloud.book.group.dto.GroupClassifyQrcodeDTO;
import com.pcloud.book.keywords.biz.BookKeywordBiz;
import com.pcloud.book.keywords.dto.KeywordDTO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.common.utils.string.StringUtil;

import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import javax.annotation.Resource;

@RestController
@RequestMapping("keywordService")
public class KeywordServiceImpl implements KeywordService {

    @Resource
    private BookGroupClassifyBiz bookGroupClassifyBiz;

    @Resource
    private BookKeywordBiz bookKeywordBiz;

    @Override
    @GetMapping("getKeywordByWxGroupId")
    public ResponseEntity<ResponseDto<List<String>>> getKeywordByWxGroupId(String wxGroupId) {
        if (StringUtil.isBlank(wxGroupId)) {
            return ResponseHandleUtil.toResponse(Lists.newArrayList());
        }
        GroupClassifyQrcodeDTO classifyQrcodeInfo = bookGroupClassifyBiz.getClassifyQrcodeInfo(wxGroupId);
        if (Objects.isNull(classifyQrcodeInfo)) {
            return ResponseHandleUtil.toResponse(Lists.newArrayList());
        }
        final List<KeywordDTO> dtos = bookKeywordBiz.listFiveKeyword(classifyQrcodeInfo.getClassifyId(), classifyQrcodeInfo.getBookGroupId());
        if (CollectionUtils.isEmpty(dtos)) {
            return ResponseHandleUtil.toResponse(Lists.newArrayList());
        }
        final List<String> keywords = dtos.stream().map(KeywordDTO::getKeywords).collect(Collectors.toList());
        return ResponseHandleUtil.toResponse(keywords);
    }
}
