/**
 * 
 */
package com.pcloud.book.consumer.raystask;

import com.pcloud.book.util.common.ThreadPoolUtils;
import com.pcloud.common.core.biz.WeektaskQueueBiz;
import com.pcloud.common.core.constant.WeektaskBehaviorCode;
import com.pcloud.common.core.constant.WeektaskCode;
import com.pcloud.common.core.dto.WeektaskMessageDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.pcloud.common.exceptions.BizException;
import com.pcloud.raystask.entity.AdviserDefault;
import com.pcloud.raystask.task.service.MainLineService;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * @描述：
 * @作者：songx
 * @创建时间：2017年4月20日,上午10:26:44
 * @版本：1.0
 */
@Component("mainLineConsr")
public class MainLineConsr {
	
	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(MainLineConsr.class);


	@Autowired
	private MainLineService mainLineService;
	@Autowired
	private WeektaskQueueBiz weektaskQueueBiz;

	/**
	 * 设置默认应用标识
	 */
	public void sendDefaultId(AdviserDefault adviserDefault) throws BizException {
		LOGGER.info("【rays小游戏(消)】设置默认应用标识,<START>");
		try {
			mainLineService.sendDefaultId(adviserDefault);
		} catch (Exception e) {
			LOGGER.error("【rays小游戏(消)】设置默认应用标识.[sendDefaultId]:" + e.getMessage(), e);
		}
	}

	/**
	 * 周任务埋点
	 *
	 * @param bookId
	 *            图书标识
	 * @param adviserId
	 *            编辑标识
	 */
	public void sendAddBookTask(Long bookId, Long adviserId) {
		ThreadPoolUtils.SEND_MESSAGE_THREAD_POOL.execute(() -> {
			// 一本书刊
			WeektaskMessageDto weektaskMessageDto = new WeektaskMessageDto();
			weektaskMessageDto.setWeektaskCode(WeektaskCode.W_ADD_ONE_BOOK);
			weektaskMessageDto.setTargetId(bookId);
			weektaskMessageDto.setAdviserId(adviserId);
			weektaskMessageDto.setWeektaskBehaviorCode(WeektaskBehaviorCode.STEP_ONE);
			weektaskQueueBiz.sendMessageQueue(weektaskMessageDto);
		});
	}

	/**
	 * 周任务埋点
	 *
	 * @param bookId
	 *            图书标识
	 * @param adviserId
	 *            编辑标识
	 */
	public void sendAddBookGroupTask(Long bookId, Long adviserId) {
		ThreadPoolUtils.SEND_MESSAGE_THREAD_POOL.execute(() -> {
			// 一本书刊
			WeektaskMessageDto weektaskMessageDto = new WeektaskMessageDto();
			weektaskMessageDto.setWeektaskCode(WeektaskCode.W6_CREATE_BOOK_GROUP);
			weektaskMessageDto.setTargetId(bookId);
			weektaskMessageDto.setAdviserId(adviserId);
			weektaskMessageDto.setWeektaskBehaviorCode(WeektaskBehaviorCode.STEP_ONE);
			weektaskQueueBiz.sendMessageQueue(weektaskMessageDto);
		});
	}

}
