package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.BookClassifyBuyRecordDao;
import com.pcloud.book.group.entity.BookClassifyBuyRecord;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2019/4/19 11:56
 */
@Component("bookClassifyBuyRecordDao")
public class BookClassifyBuyRecordDaoImpl extends BaseDaoImpl<BookClassifyBuyRecord> implements BookClassifyBuyRecordDao {

    @Override
    public Boolean checkUserBuy(Long wechatUserId, Long classifyId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("wechatUserId", wechatUserId);
        paramMap.put("classifyId", classifyId);
        return this.getSqlSession().selectOne(this.getStatement("checkUserBuy"), paramMap);
    }

    @Override
    public List<Long> checkUsersBuy(List<Long> classifyId, Long wechatUserId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("wechatUserId", wechatUserId);
        paramMap.put("classifyIds", classifyId);
        return this.getSqlSession().selectList(this.getStatement("checkUsersBuy"), paramMap);
    }
}
