package com.pcloud.book.group.facade;

import com.pcloud.book.group.vo.*;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;

import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author lily
 * @date 2019/4/16 21:00
 */
@Api(description = "社区群分类")
public interface BookGroupClassifyFacade {

    @ApiOperation(value = "获取所有分类列表", httpMethod = "GET")
    @RequestMapping(value = "listAllQrByGroup", method = RequestMethod.GET)
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookGroupId", value = "token", dataType = "Long", paramType = "query")
    })
    ResponseDto<List<ListClassifyVO>> listAllClassify(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId) throws PermissionException;

    @ApiOperation(value = "新增群分类", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "addClassifyVO", value = "群分类", dataType = "AddClassifyVO", paramType = "body")
    })
    @PostMapping("addClassify")
    ResponseDto<?> addClassify(@RequestHeader("token") String token, @RequestBody AddClassifyVO addClassifyVO)
            throws BizException, PermissionException;

    @ApiOperation(value = "更新群分类", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "updateClassifyVO", value = "群分类", dataType = "UpdateClassifyVO", paramType = "body")
    })
    @PostMapping("updateClassify")
    ResponseDto<?> updateClassify(@RequestHeader("token") String token, @RequestBody UpdateClassifyVO updateClassifyVO)
            throws BizException, PermissionException;

    @ApiOperation(value = "获取群分类", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "classifyId", value = "群分类", dataType = "Long", paramType = "query")
    })
    @GetMapping("getClassify")
    ResponseDto<ClassifyVO> getClassify(@RequestHeader("token") String token, @RequestParam("classifyId") Long classifyId)
            throws BizException, PermissionException;

    @ApiOperation(value = "删除群分类", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "classifyId", value = "群分类标识", dataType = "Long", paramType = "query")
    })
    @PostMapping("deleteClassify")
    ResponseDto<?> deleteClassify(@RequestHeader("token") String token, @RequestParam("classifyId") Long classifyId)
            throws BizException, PermissionException;

    @ApiOperation(value = "更新排序值", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "updateRankVO", value = "排序", dataType = "UpdateRankVO", paramType = "body")
    })
    @PostMapping("updateClassifyRank")
    ResponseDto<?> updateClassifyRank(@RequestHeader("token") String token, @RequestBody UpdateRankVO updateRankVO)
            throws BizException, PermissionException;

    @ApiOperation(value = "获取所有分类名称", httpMethod = "GET")
    @RequestMapping(value = "listClassify", method = RequestMethod.GET)
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookGroupId", value = "token", dataType = "Long", paramType = "query")
    })
    @GetMapping("listClassify")
    ResponseDto<List<ClassifyNameVO>> listClassify(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId);

    @ApiOperation(value = "获取分类数与群数量", httpMethod = "GET")
    @RequestMapping(value = "getClassifyAndGroupCount", method = RequestMethod.GET)
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookGroupId", value = "token", dataType = "Long", paramType = "query")
    })
    @GetMapping("getClassifyAndGroupCount")
    ResponseDto<ClassifyAndGroupCountVO> getClassifyAndGroupCount(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId);

    @ApiOperation(value = "获取分类数与群总用户数", httpMethod = "GET")
    @RequestMapping(value = "getClassifyAndUserCount", method = RequestMethod.GET)
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookGroupId", value = "token", dataType = "Long", paramType = "query")
    })
    @GetMapping("getClassifyAndUserCount")
    ResponseDto<ClassifyAndUserCountVO> getClassifyAndUserCount(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId);

    @ApiOperation(value = "客户端获取群分类", httpMethod = "GET")
    @RequestMapping(value = "listClassify4Wechat", method = RequestMethod.GET)
    @ApiImplicitParams({@ApiImplicitParam(name = "userInfo", value = "userInfo", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookGroupId", value = "token", dataType = "Long", paramType = "query")
    })
    @GetMapping("getClassifyAndUserCount")
    ResponseDto<List<ListClassify4WechatVO>> listClassify4Wechat(@CookieValue("userInfo") String userInfo, @RequestParam("bookGroupId") Long bookGroupId);


    @ApiOperation(value = "客户端根据群分类获取二维码", httpMethod = "GET")
    @RequestMapping(value = "getGroupQrcode4ClassifyWechat", method = RequestMethod.GET)
    @ApiImplicitParams({@ApiImplicitParam(name = "userInfo", value = "userInfo", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "classifyId", value = "分类标识", dataType = "Long", paramType = "query")
    })
    @GetMapping("getGroupQrcode4ClassifyWechat")
    ResponseDto<GroupQrcode4ClassifyVO> getGroupQrcode4ClassifyWechat(@CookieValue("userInfo") String userInfo, @RequestParam("classifyId") Long classifyId);


    @ApiOperation(value = "获取编辑所有的分类", httpMethod = "POST")
    @RequestMapping(value = "listGroupClassifyByAdviser", method = RequestMethod.POST)
    @PostMapping("listGroupClassifyByAdviser")
    ResponseDto<PageBeanNew<BookGroupClassifyVO>> listGroupClassifyByAdviser(@RequestHeader("token") String token, @RequestBody @ApiParam("获取分类列表参数") ListGroupClassifyParam listGroupClassifyParam) throws PermissionException;

    @ApiOperation(value = "单个群统计", httpMethod = "POST")
    @RequestMapping(value = "listBookGroupQrcodeStatistic", method = RequestMethod.POST)
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "listBookGroupQrcodeParamVO", value = "单个群统计查询参数", dataType = "ListBookGroupQrcodeParamVO", paramType = "body")
    })
    @PostMapping("listBookGroupQrcodeStatistic")
    ResponseDto<PageBeanNew<BookGroupQrcodeStatisticVO>> listBookGroupQrcodeStatistic(@RequestHeader("token") String token, @RequestBody ListBookGroupQrcodeParamVO listBookGroupQrcodeParamVO) throws PermissionException;

    @ApiOperation(value = "单个群统计导出", httpMethod = "POST")
    @RequestMapping(value = "bookGroupQrcodeStatisticExport", method = RequestMethod.POST)
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "listBookGroupQrcodeExportParamVO", value = "单个群统计查询参数", dataType = "ListBookGroupQrcodeExportParamVO", paramType = "body")
    })
    @PostMapping("bookGroupQrcodeStatisticExport")
    ResponseDto<?> bookGroupQrcodeStatisticExport(@RequestHeader("token") String token, @RequestBody ListBookGroupQrcodeExportParamVO listBookGroupQrcodeExportParamVO) throws PermissionException;

    @ApiOperation(value = "获取编辑社群码统计数据", httpMethod = "GET")
    @RequestMapping(value = "getStatistic4Adviser", method = RequestMethod.GET)
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header")
    })
    @GetMapping("getStatistic4Adviser")
    ResponseDto<StatisticVO> getStatistic4Adviser(@RequestHeader("token") String token) throws PermissionException;

    @ApiOperation(value = "获取编辑的所有分类", httpMethod = "POST")
    @RequestMapping(value = "listAdviserClassify", method = RequestMethod.POST)
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "adviserClassifyParam", value = "编辑分类参数", dataType = "AdviserClassifyParam", paramType = "body")
    })
    @PostMapping("listAdviserClassify")
    ResponseDto<PageBeanNew<AdviserClassifyVO>> listAdviserClassify(@RequestHeader("token") String token, @RequestBody AdviserClassifyParam adviserClassifyParam) throws PermissionException;

    @ApiOperation("关闭或开启学习报告")
    @GetMapping("updateHasOpenLearningReport")
    ResponseDto<?> updateHasOpenLearningReport(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("classifyId") @ApiParam("分类id") Long classifyId,
            @RequestParam("hasOpenLearningReport") @ApiParam("是否开启学习报告") Boolean hasOpenLearningReport
    ) throws BizException, PermissionException;

    @ApiOperation("获取群分类学习报告相关列表")
    @GetMapping("listClassifyForLearningReport")
    ResponseDto<?> listClassifyForLearningReport(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页条数") Integer numPerPage,
            @RequestParam(value = "keyword", required = false) @ApiParam("关键词") String keyword
    ) throws BizException, PermissionException;

}
