package com.pcloud.book.group.service.impl;

import com.pcloud.book.group.biz.WeixinQrcodeBiz;
import com.pcloud.book.group.dto.BookWxQrcodeDTO;
import com.pcloud.book.group.dto.SyncWeixinGroupIdDTO;
import com.pcloud.book.group.dto.UpdateQrDTO;
import com.pcloud.book.group.dto.WeixinQrcodeCountDTO;
import com.pcloud.book.group.dto.WeixinQrcodeDTO;
import com.pcloud.book.group.service.WeixinQrcodeService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ResponseHandleUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2019/4/19 16:01
 */
@RestController("weixinQrcodeService")
@RequestMapping("weixinQrcodeService")
public class WeixinQrcodeServiceImpl implements WeixinQrcodeService {

    @Autowired
    private WeixinQrcodeBiz weixinQrcodeBiz;

    @Override
    @GetMapping("tenQuartz")
    public void tenQuartz() throws BizException {
        weixinQrcodeBiz.sendMsgByQrCount();
        weixinQrcodeBiz.setUpdateQrUrlByQuartz();
    }

    @Override
    @GetMapping("setUpdateQrUrl")
    public void setUpdateQrUrl() throws BizException {
        weixinQrcodeBiz.setUpdateQrUrl();
    }

    @Override
    @PostMapping("updateQrUrl")
    public void updateQrUrl(@RequestBody UpdateQrDTO updateQrDTO) throws BizException {
        weixinQrcodeBiz.updateQrUrl(updateQrDTO);
    }

    @Override
    @PostMapping("setUpdateQr4Error")
    public void setUpdateQr4Error(@RequestBody(required = false) List<Long> ids) throws BizException {
        weixinQrcodeBiz.setUpdateQr4Error(ids);
    }

    @Override
    @PostMapping("syncWeixinGroupId")
    public void syncWeixinGroupId(@RequestBody SyncWeixinGroupIdDTO syncWeixinGroupIdDTO) {
        weixinQrcodeBiz.syncWeixinGroupId(syncWeixinGroupIdDTO.getId(), syncWeixinGroupIdDTO.getWeixinGroupId());
    }

    @Override
    @PostMapping("sendChangeGroupNameRequest")
    public void sendChangeGroupNameRequest(@RequestBody(required = false) List<Long> ids) {
        weixinQrcodeBiz.sendChangeGroupNameRequest(ids);
    }

    @Override
    @PostMapping("sendSyncWeixinGroupIdRequest")
    public void sendSyncWeixinGroupIdRequest(@RequestBody List<Long> ids) {
        weixinQrcodeBiz.sendSyncWeixinGroupIdRequest(ids);
    }

    @Override
    @PostMapping("listWeixinQrcodeCountByRobot")
    public ResponseEntity<ResponseDto<Map<Long, WeixinQrcodeCountDTO>>> listWeixinQrcodeCountByRobot(@RequestBody List<Long> robotIds) {
        return ResponseHandleUtil.toResponse(weixinQrcodeBiz.listWeixinQrcodeCountByRobot(robotIds));
    }

    @Override
    @GetMapping("getOneQrcode")
    public ResponseEntity<ResponseDto<WeixinQrcodeDTO>> getOneQrcode() {
        return ResponseHandleUtil.toResponse(weixinQrcodeBiz.getOneQrcode());
    }

    @Override
    @GetMapping("listAvailableGroupByPage")
    public ResponseEntity<ResponseDto<List<BookWxQrcodeDTO>>> listAvailableGroupByPage(@RequestParam("currentPage") Integer currentPage,
                                                                                       @RequestParam("numPerPage") Integer numPerPage) {
        return ResponseHandleUtil.toResponse(weixinQrcodeBiz.listAvailableGroupByPage(currentPage, numPerPage));
    }

    @Override
    @GetMapping("listOver10AvailableGroupByPage")
    public ResponseEntity<ResponseDto<List<BookWxQrcodeDTO>>> listOver10AvailableGroupByPage(@RequestParam("currentPage") Integer currentPage,
                                                                                       @RequestParam("numPerPage") Integer numPerPage) {
        return ResponseHandleUtil.toResponse(weixinQrcodeBiz.listOver10AvailableGroupByPage(currentPage, numPerPage));
    }

    @Override
    @GetMapping("inviteNewRobot")
    public void inviteNewRobot(@RequestParam("wxUserId") String wxUserId) {
        weixinQrcodeBiz.inviteNewRobot(wxUserId);
    }

    @Override
    @RequestMapping(value = "getGroupVersionIp", method = RequestMethod.POST)
    public ResponseEntity<ResponseDto<Map<String, BookWxQrcodeDTO>>> getGroupVersionIp(@RequestBody List<String> wxGroupIds) {
        return ResponseHandleUtil.toResponse(weixinQrcodeBiz.getGroupVersion(wxGroupIds));
    }

}
